/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class NmxBusTxBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 66;
    static final int OFFSET_TO_TXPKTS = 5;
    static final int OFFSET_TO_TXBYTES = 9;
    static final int OFFSET_TO_OVERRUN = 13;
    static final int OFFSET_TO_DISCARD = 15;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int NUM_GOOD_MSGS_COL = 2;
    public static final int NUM_BYTES_SENT_COL = 3;
    public static final int NUM_TX_UNDERRUNS_COL = 4;
    public static final int NUM_DISCARDED_PKTS_COL = 5;

    public NmxBusTxBundle() {
        super(66);
    }

    public NmxBusTxBundle(byte[] buffer, int index) {
        super(buffer, index, 66);
    }

    public NmxBusTxBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 66);
    }

    public SohBundle createBundle() {
        return new NmxBusTxBundle();
    }

    public int getTxPackets() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public int getTxBytes() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public int getTxOverruns() {
        return LittleEndian.readUShort(this.guts, 13);
    }

    public int getDiscardedPackets() {
        return LittleEndian.readUShort(this.guts, 15);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new NmxBusTxBundle(bytes, index);
    }

    public String getCsvName() {
        return "nbt";
    }

    public String getCsvTitle() {
        return "NMXbus Tx";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%14d");
        sb.append("," + f.form(this.getTxPackets()));
        sb.append("," + f.form(this.getTxBytes()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getTxOverruns()));
        sb.append("," + f.form(this.getDiscardedPackets()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getTxPackets());
            }
            case 3: {
                return new Integer(this.getTxBytes());
            }
            case 4: {
                return new Integer(this.getTxOverruns());
            }
            case 5: {
                return new Integer(this.getDiscardedPackets());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "#Good Msgs Sent";
            }
            case 3: {
                return "#Bytes Sent";
            }
            case 4: {
                return "#Tx FIFO Underruns";
            }
            case 5: {
                return "#Discarded Pkts";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "NMX Bus Tx";
    }
}

