/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class OrionInternalTemperatureSoh
extends SohBundle {
    public static final int BUNDLE_TYPE = 35;
    static final int OFFSET_TO_CPUTEMP = 5;
    static final int OFFSET_TO_VCXOTEMP = 9;
    static final int OFFSET_TO_DSKTEMP = 13;
    private static final Format f8p2 = new Format("%8.2f");
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int USER_CPU_TEMP_COL = 2;
    public static final int VCXO_TEMP_COL = 3;
    public static final int DISK_TEMP_COL = 4;

    public OrionInternalTemperatureSoh() {
        super(35);
    }

    public OrionInternalTemperatureSoh(byte[] buffer, int index) {
        super(buffer, index, 35);
    }

    public OrionInternalTemperatureSoh(SohBundle bundle) throws InvalidInputException {
        super(bundle, 35);
    }

    public OrionInternalTemperatureSoh(float CPUTemp, float VCXOTemp, float diskTemp) {
        super(35, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, CPUTemp);
        LittleEndian.writeFloat(this.guts, 9, VCXOTemp);
        LittleEndian.writeFloat(this.guts, 13, diskTemp);
    }

    public SohBundle createBundle() {
        return new OrionInternalTemperatureSoh();
    }

    public float getCPUTemp() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getVCXOTemp() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getDiskTemp() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new OrionInternalTemperatureSoh(bytes, index);
    }

    public String getCsvName() {
        return "tmp";
    }

    public String getCsvTitle() {
        return "Orion Internal Temperature SOH for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append(", " + f8p2.form(this.getCPUTemp()));
        sb.append(", " + f8p2.form(this.getVCXOTemp()));
        sb.append(", " + f8p2.form(this.getDiskTemp()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getCPUTemp());
            }
            case 3: {
                return new Double(this.getVCXOTemp());
            }
            case 4: {
                return new Double(this.getDiskTemp());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " UserCPUTemp";
            }
            case 3: {
                return " VCXOTemp";
            }
            case 4: {
                return " DiskTemp";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Orion Internal Temperature Slow SOH";
    }
}

