/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class OrionPoweringStatusSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 37;
    static final int OFFSET_TO_CHRGCRNT = 5;
    static final int OFFSET_TO_DGTZVLTG = 9;
    static final int OFFSET_TO_EXTBTRYSTS = 13;
    static final int OFFSET_TO_INTBTRYSTS = 14;
    static final int OFFSET_TO_SPLYSTS = 15;
    static final int OFFSET_TO_SWTCHSTS = 16;
    private static final int NUMBER_OF_COLUMNS = 10;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int CHARGE_CURRENT_COL = 2;
    public static final int DIGITIZER_VOLTAGE_COL = 3;
    public static final int EXT_BATT_STATUS_COL = 4;
    public static final int INT_BATT_STATUS_COL = 5;
    public static final int MAINS_STATUS_COL = 6;
    public static final int POWER_STATUS_COL = 7;
    public static final int USER_CPU_STATE_COL = 8;
    public static final int CHARGER_STATE_COL = 9;

    public OrionPoweringStatusSohBundle() {
        super(37);
    }

    public OrionPoweringStatusSohBundle(byte[] buffer, int index) {
        super(buffer, index, 37);
    }

    public OrionPoweringStatusSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 37);
    }

    public SohBundle createBundle() {
        return new OrionPoweringStatusSohBundle();
    }

    public float getChrgCrnt() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getDgtzVltg() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public int getExtBtrySts() {
        return this.guts[13];
    }

    public int getIntBtrySts() {
        return this.guts[14];
    }

    public int getSplySts() {
        return this.guts[15];
    }

    private int getSwitchStatus() {
        return this.guts[16];
    }

    public int getPwrSrc() {
        return this.getSwitchStatus() >> 0 & 7;
    }

    public int getCPUSts() {
        return this.getSwitchStatus() >> 3 & 3;
    }

    public int getChrgState() {
        return this.getSwitchStatus() >> 5 & 3;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new OrionPoweringStatusSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "pwr";
    }

    public String getCsvTitle() {
        return "Orion Powering status SOH for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%8.2f");
        sb.append("," + f.form(this.getChrgCrnt()));
        sb.append("," + f.form(this.getDgtzVltg()));
        f = new Format("%3d");
        sb.append("," + f.form(this.getExtBtrySts()));
        sb.append("," + f.form(this.getIntBtrySts()));
        sb.append("," + f.form(this.getSplySts()));
        sb.append("," + f.form(this.getPwrSrc()));
        sb.append("," + f.form(this.getCPUSts()));
        sb.append("," + f.form(this.getChrgState()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getChrgCrnt());
            }
            case 3: {
                return new Double(this.getDgtzVltg());
            }
            case 4: {
                return new Integer(this.getExtBtrySts());
            }
            case 5: {
                return new Integer(this.getIntBtrySts());
            }
            case 6: {
                return new Integer(this.getSplySts());
            }
            case 7: {
                return new Integer(this.getPwrSrc());
            }
            case 8: {
                return new Integer(this.getCPUSts());
            }
            case 9: {
                return new Integer(this.getChrgState());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "integer";
            }
            case 7: {
                return "integer";
            }
            case 8: {
                return "integer";
            }
            case 9: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 0;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "ChargeCurrent";
            }
            case 3: {
                return "DigitizerVoltage";
            }
            case 4: {
                return "ExtBatteryStatus";
            }
            case 5: {
                return "IntBatteryStatus";
            }
            case 6: {
                return "MainsStatus";
            }
            case 7: {
                return "PowerSource";
            }
            case 8: {
                return "UserCPUState";
            }
            case 9: {
                return "ChargerState";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 10;
    }

    public String getName() {
        return "Orion Powering Status Slow SOH";
    }
}

