/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class OrionSrcVoltagesSohBoundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 36;
    static final int OFFSET_TO_EXTVLTG = 5;
    static final int OFFSET_TO_INTVLTG = 9;
    static final int OFFSET_TO_VLTG = 13;
    private static final Format f10p2 = new Format("%10.2f");
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int EXTERNAL_COL = 2;
    public static final int INTERNAL_COL = 3;
    public static final int MAINS_COL = 4;

    public OrionSrcVoltagesSohBoundle() {
        super(36);
    }

    public OrionSrcVoltagesSohBoundle(byte[] buffer, int index) {
        super(buffer, index, 36);
    }

    public OrionSrcVoltagesSohBoundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 36);
    }

    public OrionSrcVoltagesSohBoundle(float extVltg, float intVltg, float Vltg) {
        super(36, (int)(System.currentTimeMillis() / 1000L));
        LittleEndian.writeFloat(this.guts, 5, extVltg);
        LittleEndian.writeFloat(this.guts, 9, intVltg);
        LittleEndian.writeFloat(this.guts, 13, Vltg);
    }

    public SohBundle createBundle() {
        return new OrionSrcVoltagesSohBoundle();
    }

    public float getExtVoltage() {
        return LittleEndian.readFloat(this.guts, 5);
    }

    public float getIntVoltage() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getMainVoltage() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new OrionSrcVoltagesSohBoundle(bytes, index);
    }

    public String getCsvName() {
        return "vlt";
    }

    public String getCsvTitle() {
        return "Orion source voltages SOH for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append("," + f10p2.form(this.getExtVoltage()));
        sb.append("," + f10p2.form(this.getIntVoltage()));
        sb.append("," + f10p2.form(this.getMainVoltage()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getExtVoltage());
            }
            case 3: {
                return new Double(this.getIntVoltage());
            }
            case 4: {
                return new Double(this.getMainVoltage());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "External";
            }
            case 3: {
                return "Internal";
            }
            case 4: {
                return "Mains";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Orion Source Voltage SOH";
    }
}

