/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class PacketReadErrorBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 42;
    static final int OFFSET_TO_PORTNUM = 5;
    static final int OFFSET_TO_BADPKT = 6;
    static final int OFFSET_TO_GOODPKT = 9;
    static final int OFFSET_TO_LOSTPKT = 12;
    static final int OFFSET_TO_RETX = 15;

    public PacketReadErrorBundle(byte[] buffer, int index) throws InvalidInputException {
        super(buffer, index, 42, "PacketReadErrorBundle");
    }

    public PacketReadErrorBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 42);
    }

    public PacketReadErrorBundle(int portNum, int badPackets, int goodPackets, int lostPackets, int reTxPackets) {
        super(42, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)portNum;
        LittleEndian.writeInt24(this.guts, 12, lostPackets);
        LittleEndian.writeInt24(this.guts, 9, goodPackets);
        LittleEndian.writeInt24(this.guts, 6, badPackets);
        LittleEndian.writeShort(this.guts, 15, (short)reTxPackets);
    }

    public int getPortNum() {
        return this.guts[5];
    }

    public int getBadPackets() {
        return LittleEndian.readUInt24(this.guts, 6);
    }

    public int getGoodPackets() {
        return LittleEndian.readUInt24(this.guts, 9);
    }

    public int getLostPackets() {
        return LittleEndian.readUInt24(this.guts, 12);
    }

    public int getReTxPackets() {
        return LittleEndian.readShort(this.guts, 15);
    }
}

