/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RM3RxBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 29;
    static final int OFFSET_TO_RCVR = 5;
    static final int OFFSET_TO_SNR = 6;
    static final int OFFSET_TO_DATAPKTS = 7;
    static final int OFFSET_TO_FLRPKTS = 9;
    static final int OFFSET_TO_BADPKTS = 11;
    static final int OFFSET_TO_DSCRDPKTS = 13;

    public RM3RxBundle() {
        super(29);
    }

    public RM3RxBundle(byte[] buffer, int index) {
        super(buffer, index, 29);
    }

    public RM3RxBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 29);
    }

    public int getRxChannel() {
        return this.guts[5];
    }

    public int getSNR() {
        return this.guts[6];
    }

    public int getDataPkts() {
        return LittleEndian.readUShort(this.guts, 7);
    }

    public int getFillerPkts() {
        return LittleEndian.readUShort(this.guts, 9);
    }

    public int getBadPkts() {
        return LittleEndian.readUShort(this.guts, 11);
    }

    public int getDscrdPkts() {
        return LittleEndian.readUShort(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new RM3RxBundle(bytes, index);
    }

    public String getCsvName() {
        switch (this.getRxChannel()) {
            case 0: {
                return "rx1";
            }
            case 1: {
                return "rx2";
            }
            case 2: {
                return "rx3";
            }
            case 3: {
                return "rx4";
            }
        }
        return "rx1";
    }

    public String getCsvTitle() {
        switch (this.getRxChannel()) {
            case 0: {
                return "RM3 receiver 1 status for Instrument";
            }
            case 1: {
                return "RM3 receiver 2 status for Instrument";
            }
            case 2: {
                return "RM3 receiver 3 status for Instrument";
            }
            case 3: {
                return "RM3 receiver 4 status for Instrument";
            }
        }
        return "RM3 receiver 1 status for Instrument";
    }

    public String getCsvHeader() {
        return "Time(longsecs),Time(date-time),SNR,DataPackets,FillerPackets,BadPackets,DiscardedPackets";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%3d");
        sb.append("," + f.form(this.getSNR()));
        f = new Format("%6d");
        sb.append("," + f.form(this.getDataPkts()));
        sb.append("," + f.form(this.getFillerPkts()));
        sb.append("," + f.form(this.getBadPkts()));
        sb.append("," + f.form(this.getDscrdPkts()));
        return sb.toString();
    }
}

