/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class RxSlotChannelBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 45;
    static final int OFFSET_TO_SLOTNUM = 5;
    static final int OFFSET_TO_TXADDR = 6;
    static final int OFFSET_TO_TXFREQ = 10;
    static final int OFFSET_TO_MODULN = 14;

    public RxSlotChannelBundle(byte[] buffer, int index) throws InvalidInputException {
        super(buffer, index, 45, "RxSlotChannelBundle");
    }

    public RxSlotChannelBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 45);
    }

    public RxSlotChannelBundle(int slotNum, int txIpAddress, int txFrequency, int modulation) {
        super(45, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)slotNum;
        LittleEndian.writeInt(this.guts, 6, txIpAddress);
        LittleEndian.writeInt(this.guts, 10, txFrequency);
        this.guts[14] = (byte)modulation;
    }

    public int getSlotNum() {
        return this.guts[5];
    }

    public int getTxIpAddress() {
        return LittleEndian.readInt(this.guts, 6);
    }

    public int getTxFrequency() {
        return LittleEndian.readInt(this.guts, 10);
    }

    public int getModulation() {
        return this.guts[14];
    }
}

