/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import ca.nanometrics.util.NmxDateFormat;

public class SohBundle {
    public static final int BSIZE = 17;
    public static final int PACKET_EOI = 9;
    public static final int OFFSET_TO_TYPE = 0;
    public static final int OFFSET_TO_TIME = 1;
    protected static final NmxDateFormat csvDateFormat = new NmxDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static final Format rawDateFormat = new Format("%11d");
    protected static final Format hexFormat = new Format("%#010x");
    protected static final Format byteFormat = new Format("%3d");
    byte[] guts = new byte[17];
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TYPE_COL = 2;
    public static final int LONG0_COL = 3;
    public static final int LONG1_COL = 4;
    public static final int LONG2_COL = 5;
    public static final int LONG3_COL = 6;
    public static final String LONG = "long";
    public static final String INTEGER = "integer";
    public static final String DOUBLE = "double";
    public static final String TIME = "time";
    public static final String FORMATTED_TIME = "formattedTime";
    public static final String STRING = "string";

    public SohBundle createBundle() {
        return new SohBundle(0);
    }

    public SohBundle(int type) {
        this.guts[0] = (byte)type;
    }

    public SohBundle(int type, int time) {
        this(type);
        this.setTimeSeconds(time);
    }

    public SohBundle(byte[] bytes, int index) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(bytes, index, this.guts, 0, 17);
    }

    public SohBundle(SohBundle rhs, int type) throws InvalidInputException {
        if (rhs.getType() != type) {
            throw new InvalidInputException("SohBundle: invalid type conversion");
        }
        try {
            System.arraycopy(rhs.guts, 0, this.guts, 0, 17);
        }
        catch (ArrayIndexOutOfBoundsException ei) {
            throw new InvalidInputException("Invalid Soh bundle");
        }
    }

    public SohBundle(byte[] buffer, int index, int type, String name) throws InvalidInputException {
        this(buffer, index);
        if (this.getType() != type) {
            throw new InvalidInputException(String.valueOf(name) + " type");
        }
    }

    protected SohBundle(byte[] buffer, int index, int type) {
        this(buffer, index);
        this.guts[0] = (byte)type;
    }

    public static int getSohBundleType(byte[] buffer, int offset) {
        return buffer[offset + 0];
    }

    public String toHexString() {
        StringBuffer sb = new StringBuffer();
        Format fmt = new Format("%02x ");
        int ix = 0;
        while (ix < 17) {
            sb.append(fmt.form(this.guts[ix] & 0xFF));
            if (ix % 4 == 0) {
                sb.append(" ");
            }
            ++ix;
        }
        return sb.toString().trim();
    }

    public int getType() {
        return this.guts[0];
    }

    public int getTimeSeconds() {
        return (int)this.getLongSeconds();
    }

    public long getLongSeconds() {
        return LittleEndian.readUInt(this.guts, 1);
    }

    public int getLongSecs() {
        return (int)this.getLongSeconds();
    }

    public void setTimeSeconds(int seconds) {
        LittleEndian.writeInt(this.guts, 1, seconds);
    }

    public byte[] getBytes() {
        byte[] clone = new byte[this.guts.length];
        System.arraycopy(this.guts, 0, clone, 0, this.guts.length);
        return clone;
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new SohBundle(bytes, index);
    }

    public String getCsvName() {
        return "err";
    }

    public String getCsvTitle() {
        return "Unrecognized SOH bundles";
    }

    public String getCsvHeader() {
        String retStr = "";
        int i = 0;
        while (i < this.getColumnCount() - 1) {
            retStr = String.valueOf(retStr) + this.getReadingHeaderByIndex(i) + ",";
            ++i;
        }
        retStr = String.valueOf(retStr) + this.getReadingHeaderByIndex(this.getColumnCount() - 1);
        return retStr;
    }

    public String getCsvDateString() {
        long time = this.getLongSecs();
        return String.valueOf(rawDateFormat.form(time)) + ",      " + csvDateFormat.format(time);
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        sb.append(", " + byteFormat.form(this.getType()));
        int ix = 0;
        while (ix < 4) {
            int val = LittleEndian.readInt(this.guts, 4 * ix + 1);
            sb.append(", " + hexFormat.form(val));
            ++ix;
        }
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return byteFormat.form(this.getType());
            }
            case 3: {
                return hexFormat.form(LittleEndian.readInt(this.guts, 1));
            }
            case 4: {
                return hexFormat.form(LittleEndian.readInt(this.guts, 5));
            }
            case 5: {
                return hexFormat.form(LittleEndian.readInt(this.guts, 9));
            }
            case 6: {
                return hexFormat.form(LittleEndian.readInt(this.guts, 13));
            }
        }
        return null;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "type";
            }
            case 3: {
                return "Long0";
            }
            case 4: {
                return "Long1";
            }
            case 5: {
                return "Long2";
            }
            case 6: {
                return "Long3";
            }
        }
        return "";
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return TIME;
            }
            case 1: {
                return FORMATTED_TIME;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return STRING;
            }
            case 4: {
                return STRING;
            }
            case 5: {
                return STRING;
            }
            case 6: {
                return STRING;
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        return 0;
    }

    public int getIndexOfReadingHeader(String header) {
        if (header == null) {
            return -1;
        }
        int i = 0;
        while (i < this.getColumnCount()) {
            String iHeader = this.getReadingHeaderByIndex(i).trim();
            if (iHeader.equalsIgnoreCase(header.trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnCount() {
        return 7;
    }

    public boolean hasPort() {
        return false;
    }

    public int getPort() {
        return -1;
    }

    public String getName() {
        return "SOH Error";
    }

    public void setPort(int port) {
    }

    public boolean emptyBundle() {
        int i = 0;
        while (i < this.guts.length) {
            if (this.guts[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isColorColumn(int col) {
        String dataType = this.getDataTypeByIndex(col);
        return dataType == DOUBLE || dataType == INTEGER || dataType == LONG;
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        return thresholds;
    }
}

