/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.RM3RxBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.packet.SohPacket;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SohDataSaver {
    private HashMap outputStreams;
    private String fileBaseName = "NoName";
    private String dirName;
    private long startTime = 0L;
    private long endTime = 0L;

    public SohDataSaver(String aDirName, String aFileBaseName) throws IOException {
        this.fileBaseName = aFileBaseName;
        this.dirName = aDirName == null || aDirName.length() == 0 ? null : aDirName;
        this.outputStreams = new HashMap();
        SohBundleFactory.init();
        if (!this.createDirectory()) {
            throw new IOException("Unable to create directory: " + this.dirName);
        }
    }

    public SohDataSaver(String aDirName, String aFileBaseName, long start, long end) throws IOException {
        this(aDirName, aFileBaseName);
        this.startTime = start;
        this.endTime = end;
    }

    public void savePacket(SohPacket sohPacket) throws IOException {
        int numBundles = sohPacket.getNumBundles();
        SohBundle bundle = new SohBundle(9);
        String instrument = sohPacket.getInstrumentName();
        int ix = 1;
        while (ix <= numBundles) {
            byte[] bundleBytes = sohPacket.getBundle(ix);
            bundle = SohBundleFactory.createBundle(bundleBytes, 0);
            if (bundle.getType() == 9) break;
            this.processBundle(bundle, instrument);
            ++ix;
        }
    }

    private void closeOutputStreams() {
        Collection values = this.outputStreams.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            BufferedWriter writer = (BufferedWriter)iter.next();
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processBundle(SohBundle bundle, String instrument) throws IOException {
        if (bundle == null) {
            return;
        }
        if (this.startTime < this.endTime && (bundle.getLongSeconds() < this.startTime || bundle.getLongSeconds() > this.endTime)) {
            return;
        }
        Integer type = new Integer(bundle.getType());
        if (type == 29) {
            type = this.getBundle29Type(bundle);
        }
        BufferedWriter writer = (BufferedWriter)this.outputStreams.get(type);
        String str = "";
        if (writer == null) {
            writer = this.dirName == null ? new BufferedWriter(new FileWriter(String.valueOf(this.fileBaseName) + "." + bundle.getCsvName())) : new BufferedWriter(new FileWriter(String.valueOf(this.dirName) + "/" + this.fileBaseName + "." + bundle.getCsvName()));
            this.outputStreams.put(type, writer);
            str = String.valueOf(bundle.getCsvTitle()) + instrument;
            writer.write(str);
            str = "\n" + bundle.getCsvHeader();
            writer.write(str);
        }
        if ((str = bundle.getCsvData()) != null) {
            str = "\n" + str;
            writer.write(str);
        }
    }

    private boolean createDirectory() {
        if (this.dirName == null) {
            return true;
        }
        File dir = this.getDirectory();
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                return false;
            }
        } else {
            dir.mkdirs();
        }
        return true;
    }

    protected File getDirectory() {
        return new File(this.dirName);
    }

    private Integer getBundle29Type(SohBundle bundle) {
        RM3RxBundle b = (RM3RxBundle)bundle;
        Integer retInt = null;
        if (b.getCsvName().equalsIgnoreCase("rx1")) {
            retInt = new Integer(261);
        } else if (b.getCsvName().equalsIgnoreCase("rx2")) {
            retInt = new Integer(262);
        } else if (b.getCsvName().equalsIgnoreCase("rx3")) {
            retInt = new Integer(263);
        } else if (b.getCsvName().equalsIgnoreCase("rx4")) {
            retInt = new Integer(264);
        }
        if (retInt == null) {
            retInt = new Integer(261);
        }
        return retInt;
    }

    public void close() {
        this.closeOutputStreams();
    }
}

