/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class TelemetryPacketSenderSohBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 58;
    static final int OFFSET_TO_PORTNUM = 5;
    static final int OFFSET_TO_BADPKT = 6;
    static final int OFFSET_TO_GOODPKT = 9;
    static final int OFFSET_TO_TXPKT = 12;
    static final int OFFSET_TO_LOSTPKT = 15;
    private static final int NUMBER_OF_COLUMNS = 7;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int PORT_COL = 2;
    public static final int BAD_PKTS_COL = 3;
    public static final int GOOD_PKTS_COL = 4;
    public static final int LOST_PKTS_COL = 5;
    public static final int TX_PKTS_COL = 6;

    public TelemetryPacketSenderSohBundle() {
        super(58);
    }

    public TelemetryPacketSenderSohBundle(byte[] buffer, int index) {
        super(buffer, index, 58);
    }

    public TelemetryPacketSenderSohBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 58);
    }

    public TelemetryPacketSenderSohBundle(int portNum, int badPackets, int goodPackets, int lostPackets, int txPackets) {
        super(58, (int)(System.currentTimeMillis() / 1000L));
        this.guts[5] = (byte)portNum;
        LittleEndian.writeInt24(this.guts, 6, badPackets);
        LittleEndian.writeInt24(this.guts, 9, goodPackets);
        LittleEndian.writeInt24(this.guts, 12, txPackets);
        LittleEndian.writeShort(this.guts, 15, (short)lostPackets);
    }

    public SohBundle createBundle() {
        return new TelemetryPacketSenderSohBundle();
    }

    public int getPort() {
        return this.guts[5];
    }

    public void setPort(int port) {
        if (this.emptyBundle()) {
            return;
        }
        Integer p = new Integer(port);
        byte[] bytes = new byte[17];
        int index = 0;
        while (index < 17) {
            bytes[index] = index != 5 ? this.guts[index] : p.byteValue();
            ++index;
        }
        this.guts = bytes;
    }

    public boolean hasPort() {
        return true;
    }

    public int getBadPackets() {
        return LittleEndian.readUInt24(this.guts, 6);
    }

    public int getGoodPackets() {
        return LittleEndian.readUInt24(this.guts, 9);
    }

    public int getLostPackets() {
        return LittleEndian.readShort(this.guts, 15);
    }

    public int getReTxPackets() {
        return LittleEndian.readUInt24(this.guts, 12);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new TelemetryPacketSenderSohBundle(bytes, index);
    }

    public String getCsvName() {
        return "tps";
    }

    public String getCsvTitle() {
        return "Packet sender status for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%3d");
        sb.append("," + f.form(this.getPort()));
        f = new Format("%8d");
        sb.append("," + f.form(this.getBadPackets()));
        sb.append("," + f.form(this.getGoodPackets()));
        sb.append("," + f.form(this.getLostPackets()));
        sb.append("," + f.form(this.getReTxPackets()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getPort());
            }
            case 3: {
                return new Integer(this.getBadPackets());
            }
            case 4: {
                return new Integer(this.getGoodPackets());
            }
            case 5: {
                return new Integer(this.getLostPackets());
            }
            case 6: {
                return new Integer(this.getReTxPackets());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
            case 6: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " Port";
            }
            case 3: {
                return " BadPackets";
            }
            case 4: {
                return " GoodPackets";
            }
            case 5: {
                return " LostPackets";
            }
            case 6: {
                return " TxPackets";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getName() {
        return "NMXP Transmit Errors";
    }
}

