/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class TimeServerPllBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 61;
    static final int OFFSET_TO_UWTIME = 5;
    static final int OFFSET_TO_QUALITY = 8;
    static final int OFFSET_TO_TIMEERR = 9;
    static final int OFFSET_TO_FREQERR = 13;
    static final int OFFSET_TO_UNLOCK = 14;
    static final double COUNTS_TO_NANOS = 104.17;
    static final double COUNTS_TO_PPM = 0.1;
    static final double COUNTS_TO_HZ = 0.96;
    public static final String[] timeQuality = new String[]{"< 100 nanosecond", "< 200 nanosecond", "< 500 nanosecond", "< 1 microsecond", "< 2 microsecond", "< 5 microsecond", "< 10 microsecond", "< 20 microsecond", "< 50 microsecond", "< 100 microsecond", "< 1 millisecond", "< 10 millisecond", "< 100 millisecond", "< 1 second", "< 10 seconds", "> 10 seconds"};
    public static final String[] pllStatus = new String[]{"initializing", "no time", "raw time", "approximate time", "measuring frequency", "reserved 5", "reserved 6", "No lock", "Coarse lock", "Fine lock", "Superfine lock", "reserved 11", "reserved 12", "reserved 13", "reserved 14", "reserved 15"};
    private static final int NUMBER_OF_COLUMNS = 8;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int FAST_COUNT_COL = 2;
    public static final int STATUS_COL = 3;
    public static final int TIME_ACCURACY_COL = 4;
    public static final int TIME_ERROR_COL = 5;
    public static final int FREQ_ERROR_COL = 6;
    public static final int GPS_LOCK_LOSS_COL = 7;

    public TimeServerPllBundle() {
        super(61);
    }

    public TimeServerPllBundle(byte[] buffer, int index) {
        super(buffer, index, 61);
    }

    public TimeServerPllBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 61);
    }

    public SohBundle createBundle() {
        return new TimeServerPllBundle();
    }

    public int getUWTimeCounts() {
        return LittleEndian.readUInt24(this.guts, 5);
    }

    public double getUWTimeNanos() {
        return 104.17 * (double)this.getUWTimeCounts();
    }

    public int getTimeErrorCounts() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public double getTimeErrorNanos() {
        return 104.17 * (double)this.getTimeErrorCounts();
    }

    public int getFreqErrorCounts() {
        return this.guts[13];
    }

    public double getFreqErrorPpm() {
        return 0.1 * (double)this.getFreqErrorCounts();
    }

    public double getFreqErrorHz() {
        return 0.96 * (double)this.getFreqErrorCounts();
    }

    public int getSecondsSinceLocked() {
        return LittleEndian.readUInt24(this.guts, 14);
    }

    public int getTimeQualityNumber() {
        return this.guts[8] >> 4 & 0xF;
    }

    public int getPllStatusNumber() {
        return this.guts[8] & 0xF;
    }

    public String getTimeQuality() {
        return timeQuality[this.getTimeQualityNumber()];
    }

    public String getPllStatus() {
        return pllStatus[this.getPllStatusNumber()];
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new TimeServerPllBundle(bytes, index);
    }

    public String getCsvName() {
        return "tst";
    }

    public String getCsvTitle() {
        return "TimeServer TimePLL: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%14.2f");
        sb.append("," + f.form(this.getUWTimeNanos()));
        f = new Format("%2d");
        sb.append("," + f.form(this.getPllStatusNumber()));
        sb.append("," + f.form(this.getTimeQualityNumber()));
        f = new Format("%8.2f");
        sb.append("," + f.form(this.getTimeErrorNanos()));
        sb.append("," + f.form(this.getFreqErrorHz()));
        f = new Format("%12d");
        sb.append("," + Integer.toString(this.getSecondsSinceLocked()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getUWTimeNanos());
            }
            case 3: {
                return new Integer(this.getPllStatusNumber());
            }
            case 4: {
                return new Integer(this.getTimeQualityNumber());
            }
            case 5: {
                return new Double(this.getTimeErrorNanos());
            }
            case 6: {
                return new Double(this.getFreqErrorHz());
            }
            case 7: {
                return new Integer(this.getSecondsSinceLocked());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "double";
            }
            case 7: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "FastCount(ns)";
            }
            case 3: {
                return "Status";
            }
            case 4: {
                return "TimeAccuracy";
            }
            case 5: {
                return "Time Error(ns)";
            }
            case 6: {
                return "Freq Error(Hz)";
            }
            case 7: {
                return "Time GPS lock loss(s)";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 5: {
                thresholds[0] = -100000.0;
                thresholds[1] = -2000.0;
                thresholds[2] = 2000.0;
                thresholds[3] = 100000.0;
                break;
            }
            case 6: {
                thresholds[0] = -10.0;
                thresholds[1] = -1.0;
                thresholds[2] = 1.0;
                thresholds[3] = 10.0;
            }
        }
        return thresholds;
    }

    public boolean isColorColumn(int index) {
        switch (index) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return false;
            }
        }
        return false;
    }

    public int getColumnCount() {
        return 8;
    }

    public String getName() {
        return "Time Server Time PLL";
    }
}

