/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class VSatTransmitterBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 50;
    static final int OFFSET_TO_IP = 5;
    static final int OFFSET_TO_TXFREQ = 9;
    static final int OFFSET_TO_TXLEVEL = 13;
    private static final int NUMBER_OF_COLUMNS = 5;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int TRANS_IP_COL = 2;
    public static final int TRANS_FREQ_COL = 3;
    public static final int TRANS_LEVEL_COL = 4;

    public VSatTransmitterBundle() {
        super(50);
    }

    public VSatTransmitterBundle(byte[] buffer, int index) {
        super(buffer, index, 50);
    }

    public VSatTransmitterBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 50);
    }

    public SohBundle createBundle() {
        return new VSatTransmitterBundle();
    }

    public int getSlotId() {
        return LittleEndian.readInt(this.guts, 5);
    }

    public String getTxIp() {
        return this.getSlotIdName(this.getSlotId());
    }

    public double getTxFreq() {
        int val = LittleEndian.readInt(this.guts, 9);
        return (double)val / 10000.0;
    }

    public float getTxLevel() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new VSatTransmitterBundle(bytes, index);
    }

    public String getCsvName() {
        return "txb";
    }

    public String getCsvTitle() {
        return "VSat: Transmitter for Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%15s");
        sb.append("," + f.form(this.getTxIp()));
        f = new Format("%14.2f");
        sb.append("," + f.form(this.getTxFreq()));
        sb.append("," + f.form(this.getTxLevel()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getTxIp();
            }
            case 3: {
                return new Double(this.getTxFreq());
            }
            case 4: {
                return new Double(this.getTxLevel());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "TransmitterIP";
            }
            case 3: {
                return "TransmitterFreq(MHz)";
            }
            case 4: {
                return "TransmitterLevel";
            }
        }
        return "";
    }

    public double[] getThresholds(int index) {
        double[] thresholds = new double[]{0.0, 10.0, 20.0, 30.0};
        switch (index) {
            case 3: {
                thresholds[0] = 0.0;
                thresholds[1] = 950.0;
                thresholds[2] = 1450.0;
                thresholds[3] = 2000.0;
                break;
            }
            case 4: {
                thresholds[0] = 5.0;
                thresholds[1] = 10.0;
                thresholds[2] = 400.0;
                thresholds[3] = 700.0;
            }
        }
        return thresholds;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getName() {
        return "Transmitter Port SOH";
    }
}

