/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class VcxoCalibrationBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 7;
    static final int OFFSET_TO_VCXO = 5;
    static final int OFFSET_TO_DIFF = 7;
    static final int OFFSET_TO_TIME_ERR = 9;
    static final int OFFSET_TO_FREQ_ERR = 11;
    static final int OFFSET_TO_TEMPTURE = 13;
    static final int OFFSET_TO_PLL_STAT = 15;
    static final int OFFSET_TO_GPS_STAT = 16;
    static final double COUNT_DURATION = 2.604166666666667E-7;
    static final String[] PLL_STATUS = new String[]{"Error", "Fine lock", "Coarse lock", "Free-running, GPS off", "Free-running, GPS on", "Error"};
    static final int MAX_PLL_STATUS = PLL_STATUS.length - 1;
    static final String[] GPS_STATUS = new String[]{"3D Nav", "2D Nav", "Tracking", "Searching", "GPS Off", "Error"};
    static final int MAX_GPS_STATUS = GPS_STATUS.length - 1;
    private static final int NUMBER_OF_COLUMNS = 9;
    private static final int TIME_IN_SECONDS_COL = 0;
    private static final int FORMATTED_TIME_COL = 1;
    private static final int VCXO_VALUE_COL = 2;
    private static final int TIME_DIFF_AT_LOCK_COL = 3;
    private static final int TIME_ERROR_COL = 4;
    private static final int FREQ_ERROR_COL = 5;
    private static final int CRYSTAL_TEMP_COL = 6;
    private static final int PLL_STATUS_COL = 7;
    private static final int GPS_STATUS_COL = 8;

    public VcxoCalibrationBundle() {
        super(7);
    }

    public VcxoCalibrationBundle(byte[] buffer, int index) {
        super(buffer, index, 7);
    }

    public VcxoCalibrationBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 7);
    }

    public VcxoCalibrationBundle(int timeSeconds, int vcxoCounts, int timeDiffAtLockCounts, int timeErrCounts, int freqErrCounts, int temperatureCounts, int pllStatus, int gpsStatus) throws Exception {
        super(7, timeSeconds);
        LittleEndian.writeShort(this.guts, 5, (short)vcxoCounts);
        LittleEndian.writeShort(this.guts, 7, (short)timeDiffAtLockCounts);
        LittleEndian.writeShort(this.guts, 9, (short)timeErrCounts);
        LittleEndian.writeShort(this.guts, 11, (short)freqErrCounts);
        LittleEndian.writeShort(this.guts, 13, (short)temperatureCounts);
        this.guts[15] = (byte)pllStatus;
        this.guts[16] = (byte)gpsStatus;
    }

    public SohBundle createBundle() {
        return new VcxoCalibrationBundle();
    }

    public double getVcxoValue() {
        short retVal = LittleEndian.readShort(this.guts, 5);
        return (double)retVal / 16.0;
    }

    public int getTimeDiffCounts() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public int getTimeErrorCounts() {
        return LittleEndian.readShort(this.guts, 9);
    }

    public int getFreqErrorCounts() {
        return LittleEndian.readShort(this.guts, 11);
    }

    public int getCrystalTemperature() {
        return LittleEndian.readShort(this.guts, 13);
    }

    public int getPllStatus() {
        return this.guts[15];
    }

    public int getGpsStatus() {
        return this.guts[16];
    }

    public double getTimeDiffAtLock() {
        return (double)this.getTimeDiffCounts() * 2.604166666666667E-7;
    }

    public double getTimeErrorSeconds() {
        return (double)this.getTimeErrorCounts() * 2.604166666666667E-7;
    }

    public double getFrequencyError() {
        int pllStatus = this.getPllStatus();
        if (pllStatus == 2) {
            return (double)this.getFreqErrorCounts() * 2.604166666666667E-7;
        }
        if (pllStatus == 1) {
            return (double)this.getFreqErrorCounts() * 2.604166666666667E-7 / 16.0;
        }
        return 0.0;
    }

    public String getPllStatusString() {
        int pllStatus = this.getPllStatus();
        if (pllStatus < 0 || pllStatus > MAX_PLL_STATUS) {
            pllStatus = MAX_PLL_STATUS;
        }
        return PLL_STATUS[pllStatus];
    }

    public String getGpsStatusString() {
        int gpsStatus = this.getGpsStatus();
        if (gpsStatus < 0 || gpsStatus > MAX_GPS_STATUS) {
            gpsStatus = MAX_GPS_STATUS;
        }
        return GPS_STATUS[gpsStatus];
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new VcxoCalibrationBundle(bytes, index);
    }

    public String getCsvName() {
        return "vcx";
    }

    public String getCsvTitle() {
        return "Vcxo SOH for Instrument: ";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%10.2f");
        sb.append("," + f.form(this.getVcxoValue()));
        f = new Format("%8.1f");
        double timeInMicroSecs = this.getTimeDiffAtLock() * 1000000.0;
        sb.append("," + f.form(timeInMicroSecs));
        timeInMicroSecs = this.getTimeErrorSeconds() * 1000000.0;
        sb.append("," + f.form(timeInMicroSecs));
        timeInMicroSecs = this.getFrequencyError() * 1000000.0;
        sb.append("," + f.form(timeInMicroSecs));
        f = new Format("%7d");
        sb.append("," + f.form(this.getCrystalTemperature()));
        f = new Format("%4d");
        sb.append("," + f.form(this.getPllStatus()));
        sb.append("," + f.form(this.getGpsStatus()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 0;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Double(this.getVcxoValue());
            }
            case 3: {
                return new Double(this.getTimeDiffAtLock());
            }
            case 4: {
                return new Double(this.getTimeErrorSeconds() * 1000000.0);
            }
            case 5: {
                return new Double(this.getFrequencyError());
            }
            case 6: {
                return new Integer(this.getCrystalTemperature());
            }
            case 7: {
                return new Integer(this.getPllStatus());
            }
            case 8: {
                return new Integer(this.getGpsStatus());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "double";
            }
            case 6: {
                return "integer";
            }
            case 7: {
                return "integer";
            }
            case 8: {
                return "integer";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return "Time(date-time)";
            }
            case 2: {
                return "VcxoValue";
            }
            case 3: {
                return "TimeDiffAtLock";
            }
            case 4: {
                return "TimeError";
            }
            case 5: {
                return "FreqError";
            }
            case 6: {
                return "CrystalTemp";
            }
            case 7: {
                return "PLLStatus";
            }
            case 8: {
                return "GPSStatus";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 9;
    }

    public String getName() {
        return "VCXO Calibration Data";
    }
}

