/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    private void incCount(int value) {
        int temp = this.written + value;
        if (temp < 0) {
            temp = Integer.MAX_VALUE;
        }
        this.written = temp;
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
        this.incCount(1);
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        this.incCount(1);
    }

    public final void writeShort(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.incCount(2);
    }

    public final void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    public final void writeInt(int v) throws IOException {
        this.out.write(v >>> 0 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 24 & 0xFF);
        this.incCount(4);
    }

    public final void writeLong(long v) throws IOException {
        this.out.write((int)(v >>> 0) & 0xFF);
        this.out.write((int)(v >>> 8) & 0xFF);
        this.out.write((int)(v >>> 16) & 0xFF);
        this.out.write((int)(v >>> 24) & 0xFF);
        this.out.write((int)(v >>> 32) & 0xFF);
        this.out.write((int)(v >>> 40) & 0xFF);
        this.out.write((int)(v >>> 48) & 0xFF);
        this.out.write((int)(v >>> 56) & 0xFF);
        this.incCount(8);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.out.write((byte)s.charAt(i));
            ++i;
        }
        this.incCount(len);
    }

    public final void writeChars(String s) throws IOException {
        OutputStream out = this.out;
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    public final void writeUTF(String str) throws IOException {
        char c;
        OutputStream out = this.out;
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(utflen);
        i = 0;
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c >> 0 & 0x3F);
                this.incCount(2);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c >> 0 & 0x3F);
                this.incCount(1);
            }
            ++i;
        }
        this.incCount(strlen);
    }

    public final int size() {
        return this.written;
    }
}

