/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public abstract class ChannelAddRequest
extends ChannelRequest {
    protected int maxDelay;
    protected boolean wantsBufData;

    protected ChannelAddRequest(int[] chnlKeys, int dataType, int nmxpType, int maxDelay, boolean wantsBufData) {
        super(chnlKeys, dataType, nmxpType);
        this.maxDelay = maxDelay;
        this.wantsBufData = wantsBufData;
    }

    protected ChannelAddRequest(int dataType, int nmxpType) throws InvalidInputException {
        super(dataType, nmxpType);
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4;
    }

    protected int writeChannels(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        return super.getDataLength();
    }

    protected int readChannels(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        return super.getDataLength();
    }

    public void writeTo(byte[] buffer, int offset) {
        int bytesWritten = this.writeChannels(buffer, offset);
        int doBuff = this.wantsBufData ? 1 : 0;
        BigEndian.writeInt(buffer, offset += bytesWritten, this.maxDelay);
        BigEndian.writeInt(buffer, offset + 4, doBuff);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int bytesRead;
        if (buffer.length - (offset += (bytesRead = this.readChannels(buffer, offset, length))) < 8) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(buffer, offset);
        this.wantsBufData = 1 == BigEndian.readInt(buffer, offset + 4);
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public boolean wantsBuffers() {
        return this.wantsBufData;
    }
}

