/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelSet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ChannelCommand
extends ChannelSet {
    public static final int LONG_SIZE = 8;
    private long permission = 0L;

    public ChannelCommand(int[] chnlKeys, String password) {
        super(chnlKeys);
        this.permission = ChannelCommand.encode(password);
    }

    public ChannelCommand(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public ChannelCommand() {
    }

    public int getDataLength() {
        return super.getDataLength() + 8;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        BigEndian.writeLong(buffer, offset += super.getDataLength(), this.permission);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        if (buffer.length - (offset += super.getDataLength()) < 8) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.permission = BigEndian.readLong(buffer, offset);
    }

    public static long encode(String password) {
        long value = 0L;
        if (password.length() < 8) {
            password = password.concat("Req1eSt8");
        }
        byte[] data = password.getBytes();
        int ix = 0;
        while (ix < 8) {
            value |= (long)((data[ix] ^ 0xA5) << 8 * ix);
            ++ix;
        }
        return value;
    }

    public long getPermission() {
        return this.permission;
    }
}

