/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.ChannelAddRequest;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class DataAddRequest
extends ChannelAddRequest {
    public static final int MSG_TYPE = 120;
    private static final int NMXP_TYPE = 1;
    private int outputType;

    public DataAddRequest(int[] chnlKeys, int maxDelay, int outputType, boolean wantsBufData) {
        super(chnlKeys, 120, 1, maxDelay, wantsBufData);
        this.outputType = outputType;
    }

    public DataAddRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(120, 1);
        this.readFrom(buffer, offset, length);
    }

    public int getDataLength() {
        return super.getDataLength() + 4 + 4 + 4;
    }

    public void writeTo(byte[] buffer, int offset) {
        int bytesWritten = this.writeChannels(buffer, offset);
        int doBuff = this.wantsBufData ? 1 : 0;
        BigEndian.writeInt(buffer, offset += bytesWritten, this.maxDelay);
        BigEndian.writeInt(buffer, offset + 4, this.outputType);
        BigEndian.writeInt(buffer, offset + 8, doBuff);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        int bytesRead;
        if (buffer.length - (offset += (bytesRead = this.readChannels(buffer, offset, length))) < 12) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
        this.maxDelay = BigEndian.readInt(buffer, offset);
        this.outputType = BigEndian.readInt(buffer, offset + 4);
        this.wantsBufData = 1 == BigEndian.readInt(buffer, offset + 8);
    }

    public int getOutputType() {
        return this.outputType;
    }
}

