/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.CalibrationCommand;
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.CalibrationInfoRequest;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.CalibrationResult;
import ca.nanometrics.msg.CancelCommandRequest;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.CommandResult;
import ca.nanometrics.msg.ConnectMessage;
import ca.nanometrics.msg.DataAddRequest;
import ca.nanometrics.msg.DataRemoveRequest;
import ca.nanometrics.msg.ErrorMessage;
import ca.nanometrics.msg.EventAddRequest;
import ca.nanometrics.msg.EventRemoveRequest;
import ca.nanometrics.msg.MassCenterCommand;
import ca.nanometrics.msg.MassCenterResult;
import ca.nanometrics.msg.MessageDecoder;
import ca.nanometrics.msg.NmxpAddRequest;
import ca.nanometrics.msg.NmxpRemoveRequest;
import ca.nanometrics.msg.NmxpSequenceRequest;
import ca.nanometrics.msg.RequestPending;
import ca.nanometrics.msg.SensorCommandRequest;
import ca.nanometrics.msg.SerialAddRequest;
import ca.nanometrics.msg.SerialRemoveRequest;
import ca.nanometrics.msg.SohAddRequest;
import ca.nanometrics.msg.SohRemoveRequest;
import ca.nanometrics.msg.TerminateMessage;
import ca.nanometrics.msg.TriggerAddRequest;
import ca.nanometrics.msg.TriggerRemoveRequest;
import ca.nanometrics.packet.DecompDataPacket;
import ca.nanometrics.packet.DoDRequestPacket;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.NmxPacketFactory;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.RawPacket;
import ca.nanometrics.packet.StaLtaTrigger;
import java.io.IOException;

public class DefaultMessageDecoder
implements MessageDecoder {
    private static final String DECODER = "DefaultMessageDecoder";

    public Packable decodeMessage(int type, int length, byte[] buffer) throws IOException {
        if (type == 1) {
            return NmxPacketFactory.makePacket(buffer, 0, length);
        }
        if (type == 4) {
            return new DecompDataPacket(buffer, 0, length);
        }
        if (type == 5) {
            return new StaLtaTrigger(buffer, 0, length);
        }
        if (type == 6) {
            return new EventPacket(buffer, 0, length);
        }
        if (type == 100) {
            return new ConnectMessage(buffer, 0, length);
        }
        if (type == 110) {
            return new RequestPending(buffer, 0, length);
        }
        if (type == 190) {
            return new ErrorMessage(buffer, 0, length);
        }
        if (type == 200) {
            return new TerminateMessage(buffer, 0, length);
        }
        if (type == 120) {
            return new DataAddRequest(buffer, 0, length);
        }
        if (type == 121) {
            return new SohAddRequest(buffer, 0, length);
        }
        if (type == 124) {
            return new SerialAddRequest(buffer, 0, length);
        }
        if (type == 122) {
            return new TriggerAddRequest(buffer, 0, length);
        }
        if (type == 123) {
            return new EventAddRequest(buffer, 0, length);
        }
        if (type == 125) {
            return new NmxpAddRequest(buffer, 0, length);
        }
        if (type == 145) {
            return new NmxpSequenceRequest(buffer, 0, length);
        }
        if (type == 130) {
            return new DataRemoveRequest(buffer, 0, length);
        }
        if (type == 131) {
            return new SohRemoveRequest(buffer, 0, length);
        }
        if (type == 134) {
            return new SerialRemoveRequest(buffer, 0, length);
        }
        if (type == 132) {
            return new TriggerRemoveRequest(buffer, 0, length);
        }
        if (type == 133) {
            return new EventRemoveRequest(buffer, 0, length);
        }
        if (type == 135) {
            return new NmxpRemoveRequest(buffer, 0, length);
        }
        if (type == 102) {
            return new CalibrationInfoRequest(buffer, 0, length);
        }
        if (type == 140) {
            return new CalibrationCommand(buffer, 0, length);
        }
        if (type == 141) {
            return new MassCenterCommand(buffer, 0, length);
        }
        if (type == 142) {
            return new SensorCommandRequest(buffer, 0, length);
        }
        if (type == 143) {
            return new CancelCommandRequest(buffer, 0, length);
        }
        if (type == 191) {
            return new CalibrationResult(buffer, 0, length);
        }
        if (type == 192) {
            return new MassCenterResult(buffer, 0, length);
        }
        if (type == 193) {
            return new CommandResult(buffer, 0, length);
        }
        if (type == 150) {
            return new ChannelList(buffer, 0, length);
        }
        if (type == 151) {
            return new CalibrationInfoTable(buffer, 0, length);
        }
        if (type == 194) {
            return new CalibrationEventMessage(buffer, 0, length);
        }
        if (type == 2) {
            return new DoDRequestPacket(buffer, 0, length);
        }
        return new RawPacket(type, length, buffer);
    }
}

