/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.msg.CommandRequest;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.InvalidInputException;

public class SensorCommandRequest
extends CommandRequest
implements Packable {
    public static final int MSG_TYPE = 142;
    public static final int LONG_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int BYTE_SIZE = 1;
    public static final int CHAN_SIZE = 3;
    private byte[] commandPacketBytes;

    public SensorCommandRequest(String _identifier, String _username, String _instrument, String[] _channels, byte[] _commandPacket) {
        super(_identifier, _username, _instrument, _channels);
        this.commandPacketBytes = _commandPacket;
    }

    public SensorCommandRequest(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public int getDataLength() {
        int length = super.getDataLength() + this.commandPacketBytes.length;
        return length;
    }

    public int getDataType() {
        return 142;
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        System.arraycopy(this.commandPacketBytes, 0, buffer, offset += super.getDataLength(), this.commandPacketBytes.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.commandPacketBytes = new byte[length - (offset += super.getDataLength())];
        System.arraycopy(buffer, offset, this.commandPacketBytes, 0, length - offset);
    }

    public byte[] getCommandPacketBytes() {
        return this.commandPacketBytes;
    }

    public int getCommandPacketLength() {
        return this.commandPacketBytes.length;
    }

    public void setCommandPacketBytes(byte[] commandBytes) {
        this.commandPacketBytes = commandBytes;
    }

    public String toString() {
        return "SensorCommandRequest:  for instrument:" + this.getInstrument() + "by user: " + this.getUsername();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SensorCommandRequest) {
            SensorCommandRequest scr = (SensorCommandRequest)obj;
            if (scr.getCommandPacketLength() != this.getCommandPacketLength()) {
                return false;
            }
            byte[] equalBytes = scr.getCommandPacketBytes();
            int cpi = 0;
            while (cpi < this.getCommandPacketLength()) {
                if (equalBytes[cpi] != this.commandPacketBytes[cpi]) {
                    return false;
                }
                ++cpi;
            }
            return super.equals(scr);
        }
        return false;
    }
}

