/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.msg;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class ValidatedChannel {
    private int channelKey;
    private boolean valid;

    public ValidatedChannel() {
        this.channelKey = 0;
        this.valid = false;
    }

    public ValidatedChannel(int channelKey, boolean valid) {
        this.channelKey = channelKey;
        this.valid = valid;
    }

    public ValidatedChannel(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getChannelKey() {
        return this.channelKey;
    }

    public boolean getValid() {
        return this.valid;
    }

    public void setChannelKey(int channelKey) {
        this.channelKey = channelKey;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void writeTo(byte[] buffer, int offset) {
        byte validBool;
        BigEndian.writeInt(buffer, offset, this.channelKey);
        buffer[offset += 4] = validBool = this.valid ? (byte)1 : 0;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (buffer.length - offset < this.getDataLength()) {
            throw new InvalidInputException("readFrom: insufficient data");
        }
        this.channelKey = BigEndian.readInt(buffer, offset);
        this.valid = buffer[offset += 4] != 0;
    }

    public int getDataLength() {
        return 5;
    }
}

