/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.AsciiSerialStream;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import java.util.Vector;

public class AsciiSerialInStream
extends SerialInStream
implements AsciiSerialStream {
    private String buffer;
    private Vector objArray;
    private int currentChar;
    private int lastIndex;

    public AsciiSerialInStream(byte[] inputbuffer) throws SerialiseException {
        this.buffer = new String(inputbuffer);
        this.objArray = new Vector(1000);
        this.objArray.addElement(null);
        this.lastIndex = 0;
        this.currentChar = 0;
        try {
            this.setAccessLevel(this.readAccessLevel());
        }
        catch (Exception e) {
            throw new SerialiseException(e.getMessage());
        }
    }

    private String getString(char marker) {
        if (this.buffer.charAt(this.currentChar) == ',') {
            ++this.currentChar;
        }
        int firstChar = this.currentChar;
        int lastChar = this.buffer.indexOf(marker, firstChar);
        this.currentChar = lastChar + 1;
        return this.buffer.substring(firstChar, lastChar);
    }

    public int readAccessLevel() {
        this.currentChar = this.buffer.indexOf("APL=") + "APL=".length();
        return this.deserialiseInt();
    }

    public int deserialiseInt() {
        Integer temp = new Integer(this.getString(','));
        return temp;
    }

    public long deserialiseLong() {
        Long temp = new Long(this.getString(','));
        return temp;
    }

    public float deserialiseFloat() {
        Float temp = new Float(this.getString(','));
        return temp.floatValue();
    }

    public double deserialiseDouble() {
        Double temp = new Double(this.getString(','));
        return temp;
    }

    public char deserialiseChar() {
        String str = this.getString(',');
        return str.charAt(0);
    }

    public String deserialiseString() {
        String str = this.getString(',');
        return str;
    }

    public boolean deserialiseBool() {
        Integer temp = new Integer(this.getString(','));
        return temp == 1;
    }

    private void beginObject() {
        this.currentChar = this.buffer.indexOf(123, this.currentChar) + 1;
    }

    private void endObject() {
        this.currentChar = this.buffer.indexOf(125, this.currentChar) + 1;
    }

    public void deserialiseObject(Serialisable obj) throws SerialiseException {
        int expectedIndex;
        String target;
        if (obj == null) {
            throw new SerialiseException("attempting to deserialise into null object");
        }
        this.currentChar = this.buffer.indexOf("\r\n", this.currentChar) + "\r\n".length();
        String source = this.getString('[');
        if (!source.equals(target = obj.getClass().getName())) {
            throw new SerialiseException("deserialise source " + source + " differs from target " + target);
        }
        int index = Integer.parseInt(this.getString(']'));
        if (index != (expectedIndex = this.lastIndex + 1)) {
            throw new SerialiseException("invalid deserialisation index " + index + ", expected " + expectedIndex);
        }
        this.lastIndex = index;
        try {
            this.objArray.addElement(obj);
            this.beginObject();
            obj.restoreGuts(this);
            this.endObject();
        }
        catch (SerialiseException exc1) {
            throw exc1;
        }
        catch (Exception e) {
            throw new SerialiseException(e.getMessage());
        }
    }

    public Object deserialiseReference() throws SerialiseException {
        int index = -1;
        if (this.buffer.charAt(this.currentChar) != '(') {
            throw new SerialiseException("object reference index not fould");
        }
        ++this.currentChar;
        index = Integer.parseInt(this.getString(')'));
        if (this.buffer.charAt(this.currentChar) == ',') {
            ++this.currentChar;
        }
        if (index < 0) {
            throw new SerialiseException("object reference index < 0");
        }
        if (index > this.lastIndex) {
            throw new SerialiseException("invalid object reference index: " + index);
        }
        return this.objArray.elementAt(index);
    }
}

