/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.BoolConstraint;
import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class BoolParam
extends Param {
    boolean value = false;
    char version = (char)48;
    private BoolConstraint constraint;

    public BoolParam(String aLabel, boolean newValue, int newattrib, BoolConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public boolean getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return this.getValue() ? "true" : "false";
    }

    void validate(boolean newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(newValue ? "true" : "false", this.constraint);
        }
    }

    public void putValue(boolean newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(boolean newValue, UpdateMode mode) throws UpdateException {
        if (this.value != newValue) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public boolean valueOf(String str) throws UpdateException {
        block7: {
            block6: {
                try {
                    if (this.constraint != null) {
                        return this.constraint.valueOf(str);
                    }
                    if (!str.equalsIgnoreCase("true")) break block6;
                    return true;
                }
                catch (IllegalArgumentException iae) {
                    if (this.constraint != null) {
                        throw this.BadValue(str, this.constraint);
                    }
                    throw this.FormatError(str);
                }
            }
            if (!str.equalsIgnoreCase("false")) break block7;
            return false;
        }
        throw new IllegalArgumentException(str);
    }

    public void putValue(String str) throws UpdateException {
        boolean newValue = this.valueOf(str);
        this.putValue(newValue);
    }

    public void putValue(String str, UpdateMode mode) throws UpdateException {
        boolean newValue = this.valueOf(str);
        this.putValue(newValue, mode);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseBool(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseBool();
        this.constraint = (BoolConstraint)strm.deserialiseReference();
    }
}

