/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.DoubleConstraint;
import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class DoubleParam
extends Param {
    double value = 0.0;
    char version = (char)48;
    private DoubleConstraint constraint;

    public DoubleParam(String aLabel, double newValue, int newattrib, DoubleConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public double getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return Double.toString(this.getValue());
    }

    void validate(double newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(Double.toString(newValue), this.constraint);
        }
    }

    public void putValue(double newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(double newValue, UpdateMode mode) throws UpdateException {
        if (this.value != newValue) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public double valueOf(String str) throws UpdateException {
        try {
            if (this.constraint != null) {
                return this.constraint.valueOf(str);
            }
            Double val = Double.valueOf(str);
            return val;
        }
        catch (IllegalArgumentException iae) {
            throw this.FormatError(str);
        }
    }

    public void putValue(String str) throws UpdateException {
        double newValue = this.valueOf(str);
        this.putValue(newValue);
    }

    public void putValue(String str, UpdateMode mode) throws UpdateException {
        double newValue = this.valueOf(str);
        this.putValue(newValue, mode);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseDouble(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseDouble();
        this.constraint = (DoubleConstraint)strm.deserialiseReference();
    }
}

