/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.FloatConstraint;
import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class FloatParam
extends Param {
    float value = 0.0f;
    char version = (char)48;
    private FloatConstraint constraint;

    public FloatParam(String aLabel, float newValue, int newattrib, FloatConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public float getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return Float.toString(this.getValue());
    }

    void validate(float newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(Float.toString(newValue), this.constraint);
        }
    }

    public void putValue(float newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(float newValue, UpdateMode mode) throws UpdateException {
        if (this.value != newValue) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public float valueOf(String str) throws UpdateException {
        try {
            if (this.constraint != null) {
                return this.constraint.valueOf(str);
            }
            Float val = Float.valueOf(str);
            return val.floatValue();
        }
        catch (IllegalArgumentException iae) {
            throw this.FormatError(str);
        }
    }

    public void putValue(String str) throws UpdateException {
        float newValue = this.valueOf(str);
        this.putValue(newValue);
    }

    public void putValue(String str, UpdateMode mode) throws UpdateException {
        float newValue = this.valueOf(str);
        this.putValue(newValue, mode);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseFloat(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseFloat();
        this.constraint = (FloatConstraint)strm.deserialiseReference();
    }
}

