/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.LongConstraint;
import ca.nanometrics.naqs.config.Param;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;

public class LongParam
extends Param {
    long value = 0L;
    char version = (char)48;
    private LongConstraint constraint;

    public LongParam(String aLabel, long newValue, int newattrib, LongConstraint newConstraint) {
        super(aLabel, newattrib);
        this.constraint = newConstraint;
        this.putValue(newValue);
    }

    public long getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.constraint != null) {
            return this.constraint.getValueString(this.getValue());
        }
        return Long.toString(this.getValue());
    }

    void validate(long newValue) throws UpdateException {
        if (this.constraint != null && !this.constraint.isGood(newValue)) {
            throw this.BadValue(Long.toString(newValue), this.constraint);
        }
    }

    public void putValue(long newValue) throws UpdateException {
        this.validate(newValue);
        this.value = newValue;
    }

    public void putValue(long newValue, UpdateMode mode) throws UpdateException {
        if (this.value != newValue) {
            if (this.haveWritePermission(mode.getWho())) {
                this.validate(newValue);
                if (!mode.isTest()) {
                    this.value = newValue;
                }
            } else {
                throw this.NoPermission();
            }
        }
    }

    public long valueOf(String str) throws UpdateException {
        try {
            if (this.constraint != null) {
                return this.constraint.valueOf(str);
            }
            return Long.parseLong(str);
        }
        catch (IllegalArgumentException iae) {
            throw this.FormatError(str);
        }
    }

    public void putValue(String str) throws UpdateException {
        long newValue = this.valueOf(str);
        this.putValue(newValue);
    }

    public void putValue(String str, UpdateMode mode) throws UpdateException {
        long newValue = this.valueOf(str);
        this.putValue(newValue, mode);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        super.saveGuts(strm);
        strm.serialiseChar(this.version);
        strm.serialiseLong(this.value);
        strm.serialiseReference(this.constraint);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        super.restoreGuts(strm);
        char readVersion = strm.deserialiseChar();
        this.value = strm.deserialiseLong();
        this.constraint = (LongConstraint)strm.deserialiseReference();
    }
}

