/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.LongConstraint;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;

public class LongRange
extends LongConstraint {
    long max;
    long min;
    char version = (char)48;

    public LongRange(long newmin, long newmax) {
        this.max = newmax;
        this.min = newmin;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public String getDescription() {
        return new String(String.valueOf(this.min) + " <= x <= " + this.max);
    }

    public boolean isGood(long val) {
        return val <= this.max && val >= this.min;
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseLong(this.min);
        strm.serialiseLong(this.max);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.min = strm.deserialiseLong();
        this.max = strm.deserialiseLong();
    }
}

