/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.config;

import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.StringConstraint;

public class StringRange
extends StringConstraint {
    int maxlen = 8;
    int minlen = 0;
    char version = (char)48;

    public StringRange(int max) {
        this.maxlen = max;
        this.minlen = 0;
    }

    public StringRange(int min, int max) {
        this.maxlen = max;
        this.minlen = min;
    }

    public String getDescription() {
        return new String(String.valueOf(this.minlen) + " <= length <= " + this.maxlen);
    }

    public boolean isGood(String s) {
        return s.length() <= this.maxlen && s.length() >= this.minlen;
    }

    public void saveGuts(SerialOutStream strm) {
        strm.serialiseChar(this.version);
        strm.serialiseInt(this.minlen);
        strm.serialiseInt(this.maxlen);
    }

    public void restoreGuts(SerialInStream strm) {
        char readVersion = strm.deserialiseChar();
        this.minlen = strm.deserialiseInt();
        this.maxlen = strm.deserialiseInt();
    }
}

