/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.StationConfig;
import java.io.File;
import java.io.IOException;

public abstract class BaseChannelConfig
implements ChannelConfig {
    static final int DATA_PACKET = 1;
    static final int SOH_PACKET = 2;
    static final int APPEND_BUFF_SIZE = 4200;
    static final int INSERT_BUFF_SIZE = 4200;
    static final boolean ALWAYS_WRAP = true;
    protected StationConfig station;
    protected InstrumentConfig instrument;

    public BaseChannelConfig(StationConfig theStation, InstrumentConfig theInstrument) throws IOException {
        this.station = theStation;
        this.instrument = theInstrument;
        this.validate();
    }

    private void validate() throws IOException {
        if (this.station == null) {
            throw new IOException("null station in ChannelConfig");
        }
        if (this.instrument == null) {
            throw new IOException("null instrument in ChannelConfig");
        }
    }

    public String getStationName() {
        return this.station.getStationName();
    }

    public String getDescription() {
        return this.station.getDescription();
    }

    public double getLatitude() {
        return this.station.getLatitude();
    }

    public double getLongitude() {
        return this.station.getLongitude();
    }

    public double getElevation() {
        return this.station.getElevation();
    }

    public String getNetworkID() {
        return this.station.getNetworkID();
    }

    public int getInstrumentID() {
        return this.instrument.getInstrumentID();
    }

    public int getMemoryKb() {
        return this.instrument.getMemoryKb();
    }

    public int getRequestInterval() {
        return this.instrument.getRequestInterval();
    }

    public int getAppendSize() {
        return 4200;
    }

    public int getInsertSize() {
        return 4200;
    }

    public boolean canWrap() {
        return true;
    }

    public int getMaxBacklog() {
        return this.getMemoryKb() * 1024 / this.getPacketLength();
    }

    public String getDottedName() {
        StringBuffer name = new StringBuffer();
        name.append(this.getStationName());
        name.append('.');
        name.append(this.getChannelName());
        return name.toString();
    }

    public String getRingBufferName() {
        StringBuffer name = new StringBuffer();
        name.append('R');
        name.append(this.getDottedName());
        return name.toString();
    }

    public String getChannelPathName() {
        File file = new File(this.getRingBufferPath(), this.getRingBufferName());
        return file.getAbsolutePath();
    }
}

