/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.ChannelConfig;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChannelTable {
    private Hashtable table = new Hashtable();

    private String keyOf(String name) {
        return name.toUpperCase();
    }

    public ChannelConfig add(ChannelConfig channel) {
        String name = channel.getDottedName();
        return this.table.put(this.keyOf(name), channel);
    }

    public boolean contains(ChannelConfig channel) {
        String name = channel.getDottedName();
        int key = channel.getKey();
        return this.contains(name) || this.contains(key);
    }

    public boolean contains(String name) {
        return this.table.containsKey(this.keyOf(name));
    }

    public ChannelConfig get(String name) {
        return (ChannelConfig)this.table.get(this.keyOf(name));
    }

    public ChannelConfig remove(String name) {
        return (ChannelConfig)this.table.remove(this.keyOf(name));
    }

    public boolean contains(int key) {
        return this.get(key) != null;
    }

    public ChannelConfig get(int key) {
        Enumeration e = this.table.elements();
        while (e.hasMoreElements()) {
            ChannelConfig channel = (ChannelConfig)e.nextElement();
            if (channel.getKey() != key) continue;
            return channel;
        }
        return null;
    }

    public ChannelConfig remove(int key) {
        ChannelConfig channel = this.get(key);
        if (channel != null) {
            this.table.remove(this.keyOf(channel.getDottedName()));
        }
        return channel;
    }

    public int findKeyOf(String name) {
        ChannelConfig channel = this.get(name);
        if (channel != null) {
            return channel.getKey();
        }
        return 0;
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public int size() {
        return this.table.size();
    }
}

