/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.InstrumentPrototype;
import ca.nanometrics.packet.Instrument;
import java.io.IOException;

public class InstrumentConfig {
    private InstrumentPrototype prototype;
    private int serialNumber;
    private Integer memoryKb = null;
    private Integer bundlesPerPacket = null;
    private Integer requestInterval = null;
    private String sohChannelName = null;
    private Integer sohBufferSize = null;
    private String sohBufferPath = null;
    private String inetHostName = null;
    private Integer inetPort = null;

    public InstrumentConfig(InstrumentPrototype thePrototype, int theSerialNumber) throws IOException {
        this.prototype = thePrototype;
        this.serialNumber = theSerialNumber;
        this.validate();
    }

    private void validate() throws IOException {
        if (this.prototype == null) {
            throw new IOException("null prototype in InstrumentConfig");
        }
    }

    public void setMemoryKb(int val) {
        this.memoryKb = new Integer(val);
    }

    public void setBundlesPerPacket(int val) {
        this.bundlesPerPacket = new Integer(val);
    }

    public void setRequestInterval(int val) {
        this.requestInterval = new Integer(val);
    }

    public void setSohBufferSize(int val) {
        this.sohBufferSize = new Integer(val);
    }

    public void setInetPort(int val) {
        this.inetPort = new Integer(val);
    }

    public void setSohChannelName(String name) {
        this.sohChannelName = name;
    }

    public void setSohBufferPath(String name) {
        this.sohBufferPath = name;
    }

    public void setInetHostName(String name) {
        this.inetHostName = name;
    }

    public int getType() {
        return this.prototype.getType();
    }

    public String getModel() {
        return this.prototype.getModel();
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getMemoryKb() {
        if (this.memoryKb != null) {
            return this.memoryKb;
        }
        return this.prototype.getMemoryKb();
    }

    public int getBundlesPerPacket() {
        if (this.bundlesPerPacket != null) {
            return this.bundlesPerPacket;
        }
        return this.prototype.getBundlesPerPacket();
    }

    public int getRequestInterval() {
        if (this.requestInterval != null) {
            return this.requestInterval;
        }
        return this.prototype.getRequestInterval();
    }

    public String getSohChannelName() {
        if (this.sohChannelName != null) {
            return this.sohChannelName;
        }
        return this.prototype.getSohChannelName();
    }

    public int getSohBufferSize() {
        if (this.sohBufferSize != null) {
            return this.sohBufferSize;
        }
        return this.prototype.getSohBufferSize();
    }

    public String getSohBufferPath() {
        if (this.sohBufferPath != null) {
            return this.sohBufferPath;
        }
        return this.prototype.getSohBufferPath();
    }

    public String getInetHostName() {
        if (this.inetHostName != null) {
            return this.inetHostName;
        }
        return this.prototype.getInetHostName();
    }

    public int getInetPort() {
        if (this.inetPort != null) {
            return this.inetPort;
        }
        return this.prototype.getInetPort();
    }

    public boolean hasDynamicAddress() {
        return this.getInetHostName().equalsIgnoreCase("Dynamic");
    }

    public int getInstrumentID() {
        return Instrument.getIDOf(this.getType(), this.serialNumber);
    }
}

