/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.BaseChannelConfig;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.SerialChannelPrototype;
import ca.nanometrics.naqs.stndb.StationConfig;
import ca.nanometrics.packet.NmxPacket;
import java.io.IOException;

public class SerialChannelConfig
extends BaseChannelConfig {
    SerialChannelPrototype prototype;
    Integer port = null;
    Integer ringBufferSize = null;
    String ringBufferPath = null;

    public SerialChannelConfig(StationConfig theStation, InstrumentConfig theInstrument, SerialChannelPrototype thePrototype) throws IOException {
        super(theStation, theInstrument);
        this.prototype = thePrototype;
        this.validate();
    }

    private void validate() throws IOException {
        if (this.prototype == null) {
            throw new IOException("null prototype in SerialChannelConfig");
        }
    }

    public String getChannelName() {
        return this.prototype.getChannelName();
    }

    public String getDescription() {
        return this.prototype.getDescription();
    }

    public int getPacketLength() {
        return 17 + this.prototype.getBytesPerPacket();
    }

    public int getType() {
        return 6;
    }

    public int getFileTag() {
        return 45;
    }

    public double getAzimuth() {
        return 0.0;
    }

    public double getDip() {
        return 0.0;
    }

    public double getDepth() {
        return 0.0;
    }

    public String getResponseFile() {
        return "";
    }

    public String getSensorType() {
        return "NONE";
    }

    public String getSensitivityUnits() {
        return "NONE";
    }

    public String getCalibrationUnits() {
        return "NONE";
    }

    public int getCalEnable() {
        return 0;
    }

    public int getCalRelay() {
        return 0;
    }

    public int getMassCenterEnable() {
        return 0;
    }

    public double getMassCenterDuration() {
        return 1.0;
    }

    public int getCalibrationSource() {
        return 0;
    }

    public double getSensitivity() {
        return 1.0;
    }

    public double getSensitivityFreq() {
        return 1.0;
    }

    public double getCalCoilResistance() {
        return 1.0;
    }

    public double getCalCoilConstant() {
        return 1.0;
    }

    public int getChannel() {
        if (this.port != null) {
            return this.port;
        }
        return this.prototype.getPort();
    }

    public int getRingBufferSize() {
        if (this.ringBufferSize != null) {
            return this.ringBufferSize;
        }
        return this.prototype.getRingBufferSize();
    }

    public String getRingBufferPath() {
        if (this.ringBufferPath != null) {
            return this.ringBufferPath;
        }
        return this.prototype.getRingBufferPath();
    }

    public String getFormat() {
        return "X";
    }

    public int getKey() {
        return NmxPacket.getKeyOf(this.getType(), this.getChannel(), this.getInstrumentID());
    }

    public void setPort(int val) {
        this.port = new Integer(val);
    }

    public void setRingBufferSize(int val) {
        this.ringBufferSize = new Integer(val);
    }

    public void setRingBufferPath(String name) {
        this.ringBufferPath = name;
    }
}

