/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.naqs.stndb.ChannelPrototype;
import ca.nanometrics.naqs.stndb.ChannelTable;
import ca.nanometrics.naqs.stndb.ChannelTypeTable;
import ca.nanometrics.naqs.stndb.DataChannelConfig;
import ca.nanometrics.naqs.stndb.DetectorTable;
import ca.nanometrics.naqs.stndb.DetectorType;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.InstrumentPrototype;
import ca.nanometrics.naqs.stndb.InstrumentTable;
import ca.nanometrics.naqs.stndb.InstrumentTypeTable;
import ca.nanometrics.naqs.stndb.NetConfig;
import ca.nanometrics.naqs.stndb.SensorConfig;
import ca.nanometrics.naqs.stndb.SensorTable;
import ca.nanometrics.naqs.stndb.SerialChannelConfig;
import ca.nanometrics.naqs.stndb.SerialChannelPrototype;
import ca.nanometrics.naqs.stndb.SerialTypeTable;
import ca.nanometrics.naqs.stndb.SohChannelConfig;
import ca.nanometrics.naqs.stndb.StationConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.naqs.stndb.StationTable;
import ca.nanometrics.naqs.stndb.TriggerConfig;
import ca.nanometrics.naqs.stndb.TriggerTable;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleStationDatabase
implements StationDatabase {
    private NetConfig network = null;
    private SensorTable sensors = new SensorTable();
    private ChannelTypeTable channelTypes = new ChannelTypeTable();
    private SerialTypeTable serialTypes = new SerialTypeTable();
    private InstrumentTypeTable instrumentTypes = new InstrumentTypeTable();
    private StationTable stations = new StationTable();
    private ChannelTable channels = new ChannelTable();
    private InstrumentTable instruments = new InstrumentTable();
    private DetectorTable detectors = new DetectorTable();
    private TriggerTable triggers = new TriggerTable();

    public SimpleStationDatabase() {
    }

    public SimpleStationDatabase(String name) throws IOException {
        this.load(name);
    }

    public void load(String name) throws IOException {
        String line;
        SimpleParser input = new SimpleParser(name);
        StationConfig station = null;
        InstrumentConfig instrument = null;
        input.getHeader("Network");
        this.network = this.loadNetwork(input);
        while ((line = input.getHeader()) != null) {
            ChannelConfig channel;
            if (line.equals("ChannelPrototype")) {
                ChannelPrototype cp = this.loadChannelType(input);
                if (this.channelTypes.contains(cp)) {
                    throw input.IOX("Duplicate channel prototype:" + cp.getTypeName());
                }
                this.channelTypes.add(cp);
                continue;
            }
            if (line.equals("Channel")) {
                channel = this.loadChannel(input, station, instrument);
                if (this.channels.contains(channel)) {
                    throw input.IOX("Duplicate channel name or key");
                }
                this.channels.add(channel);
                continue;
            }
            if (line.equals("SerialChannelPrototype")) {
                SerialChannelPrototype scp = this.loadSerialType(input);
                if (this.serialTypes.contains(scp)) {
                    throw input.IOX("Duplicate serial channel prototype:" + scp.getTypeName());
                }
                this.serialTypes.add(scp);
                continue;
            }
            if (line.equals("SerialChannel")) {
                channel = this.loadSerialChannel(input, station, instrument);
                if (this.channels.contains(channel)) {
                    throw input.IOX("Duplicate channel name or key");
                }
                this.channels.add(channel);
                continue;
            }
            if (line.equals("InstrumentPrototype")) {
                InstrumentPrototype ip = this.loadInstrumentType(input);
                if (this.instrumentTypes.contains(ip)) {
                    throw input.IOX("Duplicate instrument prototype:" + ip.getTypeName());
                }
                this.instrumentTypes.add(ip);
                continue;
            }
            if (line.equals("Instrument")) {
                if (station == null) {
                    throw input.IOX("Station undefined for instrument");
                }
                instrument = this.loadInstrument(input);
                if (instrument.getSohChannelName().equals("NUL")) continue;
                if (this.instruments.contains(instrument)) {
                    throw input.IOX("Duplicate Instrument");
                }
                this.instruments.add(instrument);
                channel = this.createSohChannel(station, instrument);
                if (this.channels.contains(channel)) {
                    throw input.IOX("Duplicate Soh channel name");
                }
                this.channels.add(channel);
                continue;
            }
            if (line.equals("Sensor")) {
                SensorConfig sensor = this.loadSensor(input);
                if (this.sensors.contains(sensor)) {
                    throw input.IOX("Duplicate Sensor type:" + sensor.getTypeName());
                }
                this.sensors.add(sensor);
                continue;
            }
            if (line.equals("Station")) {
                station = this.loadStation(input);
                if (this.stations.contains(station)) {
                    throw input.IOX("Duplicate Station name");
                }
                this.stations.add(station);
                instrument = null;
                continue;
            }
            if (line.equals("DetectorType")) {
                DetectorType detector = this.loadDetector(input);
                if (this.detectors.contains(detector)) {
                    throw input.IOX("Duplicate detector type");
                }
                this.detectors.add(detector);
                continue;
            }
            if (line.equals("Trigger")) {
                TriggerConfig trigger = this.loadTrigger(input);
                if (this.triggers.contains(trigger)) {
                    throw input.IOX("Duplicate trigger");
                }
                this.triggers.add(trigger);
                continue;
            }
            throw input.IOX("Unexpected section header: " + line);
        }
        input.close();
    }

    public NetConfig loadNetwork(SimpleParser input) throws IOException {
        return new NetConfig(input.readString("Name"), input.readString("NaqsID"));
    }

    private ChannelPrototype loadChannelType(SimpleParser input, String typeName) throws IOException {
        String channelName = input.readString("Name");
        int component = input.readInt("Component");
        String sensorType = input.readString("Sensor");
        SensorConfig sensor = this.sensors.get(sensorType);
        if (sensor == null) {
            throw input.IOX("Undefined sensor type:" + sensorType);
        }
        return new ChannelPrototype(typeName, channelName, component, sensor, input.readDouble("Azimuth"), input.readDouble("Dip"), input.readDouble("Depth"), input.readInt("BundlesPerPacket"), input.readInt("RingBufferSize"), input.readString("RingBufferPath"), input.readString("ResponseFile"));
    }

    private ChannelPrototype loadChannelType(SimpleParser input) throws IOException {
        return this.loadChannelType(input, input.readString("TypeName"));
    }

    private SerialChannelPrototype loadSerialType(SimpleParser input, String typeName) throws IOException {
        return new SerialChannelPrototype(typeName, input.readString("Name"), input.readString("Description"), input.readInt("Port"), input.readInt("BytesPerPacket"), input.readInt("RingBufferSize"), input.readString("RingBufferPath"));
    }

    private SerialChannelPrototype loadSerialType(SimpleParser input) throws IOException {
        return this.loadSerialType(input, input.readString("TypeName"));
    }

    private void customizeChannel(SimpleParser input, DataChannelConfig channel, boolean doAll) throws IOException {
        if (doAll) {
            if (input.isNextLineParam("Azimuth")) {
                channel.setAzimuth(input.readDouble("Azimuth"));
            }
            if (input.isNextLineParam("Dip")) {
                channel.setDip(input.readDouble("Dip"));
            }
            if (input.isNextLineParam("Depth")) {
                channel.setDepth(input.readDouble("Depth"));
            }
            if (input.isNextLineParam("RingBufferSize")) {
                channel.setRingBufferSize(input.readInt("RingBufferSize"));
            }
            if (input.isNextLineParam("RingBufferPath")) {
                channel.setRingBufferPath(input.readString("RingBufferPath"));
            }
            if (input.isNextLineParam("ResponseFile")) {
                channel.setResponseFile(input.readString("ResponseFile"));
            }
        }
        if (input.isNextLineParam("Sensitivity")) {
            channel.setSensitivity(input.readDouble("Sensitivity"));
        }
        if (input.isNextLineParam("SensitivityFreq")) {
            channel.setSensitivityFreq(input.readDouble("SensitivityFreq"));
        }
        if (input.isNextLineParam("CalCoilResistance")) {
            channel.setCalCoilResistance(input.readDouble("CalCoilResistance"));
        }
        if (input.isNextLineParam("CalCoilConstant")) {
            channel.setCalCoilConstant(input.readDouble("CalCoilConstant"));
        }
    }

    private ChannelConfig loadChannel(SimpleParser input, StationConfig station, InstrumentConfig instrument) throws IOException {
        if (station == null) {
            throw input.IOX("Channel defined without station");
        }
        if (instrument == null) {
            throw input.IOX("Channel defined without instrument");
        }
        if (input.isNextLineParam("Prototype")) {
            String prototypeName = input.readString("Prototype");
            ChannelPrototype cp = this.channelTypes.get(prototypeName);
            if (cp == null) {
                throw input.IOX("Undefined channel prototype " + prototypeName);
            }
            DataChannelConfig chan = new DataChannelConfig(station, instrument, cp);
            this.customizeChannel(input, chan, true);
            return chan;
        }
        if (input.isNextLineParam("Name")) {
            ChannelPrototype cp = this.loadChannelType(input, "none");
            DataChannelConfig chan = new DataChannelConfig(station, instrument, cp);
            this.customizeChannel(input, chan, false);
            return chan;
        }
        throw input.IOX("expected Prototype or Name, got " + input.peekLine());
    }

    private ChannelConfig createSohChannel(StationConfig station, InstrumentConfig instrument) throws IOException {
        return new SohChannelConfig(station, instrument);
    }

    private void customizeSerialChannel(SimpleParser input, SerialChannelConfig channel) throws IOException {
        if (input.isNextLineParam("Port")) {
            channel.setPort(input.readInt("Port"));
        }
        if (input.isNextLineParam("RingBufferSize")) {
            channel.setRingBufferSize(input.readInt("RingBufferSize"));
        }
        if (input.isNextLineParam("RingBufferPath")) {
            channel.setRingBufferPath(input.readString("RingBufferPath"));
        }
    }

    private SerialChannelConfig loadSerialChannel(SimpleParser input, StationConfig station, InstrumentConfig instrument) throws IOException {
        if (station == null) {
            throw input.IOX("Channel defined without station");
        }
        if (instrument == null) {
            throw input.IOX("Channel defined without instrument");
        }
        if (input.isNextLineParam("Prototype")) {
            String prototypeName = input.readString("Prototype");
            SerialChannelPrototype cp = this.serialTypes.get(prototypeName);
            if (cp == null) {
                throw input.IOX("Undefined channel prototype " + prototypeName);
            }
            SerialChannelConfig chan = new SerialChannelConfig(station, instrument, cp);
            this.customizeSerialChannel(input, chan);
            return chan;
        }
        if (input.isNextLineParam("Name")) {
            SerialChannelPrototype cp = this.loadSerialType(input, "none");
            SerialChannelConfig chan = new SerialChannelConfig(station, instrument, cp);
            return chan;
        }
        throw input.IOX("expected Prototype or Name, got " + input.peekLine());
    }

    private InstrumentPrototype loadInstrumentType(SimpleParser input, String typeName, String model) throws IOException {
        return new InstrumentPrototype(typeName, model, input.readInt("MemoryKB"), input.readInt("SohBundlesPerPacket"), input.readInt("RequestInterval"), input.readString("SohChannelName"), input.readInt("SohBufferSize"), input.readString("SohBufferPath"), input.readString("InetHostName"), input.readInt("InetPort"));
    }

    private InstrumentPrototype loadInstrumentType(SimpleParser input) throws IOException {
        return this.loadInstrumentType(input, input.readString("TypeName"), input.readString("Model"));
    }

    private void customizeInstrument(SimpleParser input, InstrumentConfig inst, boolean doAll) throws IOException {
        if (doAll) {
            if (input.isNextLineParam("MemoryKB")) {
                inst.setMemoryKb(input.readInt("MemoryKB"));
            }
            if (input.isNextLineParam("SohBundlesPerPacket")) {
                inst.setBundlesPerPacket(input.readInt("SohBundlesPerPacket"));
            }
            if (input.isNextLineParam("RequestInterval")) {
                inst.setRequestInterval(input.readInt("RequestInterval"));
            }
            if (input.isNextLineParam("SohChannelName")) {
                inst.setSohChannelName(input.readString("SohChannelName"));
            }
            if (input.isNextLineParam("SohBufferSize")) {
                inst.setSohBufferSize(input.readInt("SohBufferSize"));
            }
            if (input.isNextLineParam("SohBufferPath")) {
                inst.setSohBufferPath(input.readString("SohBufferPath"));
            }
        }
        if (input.isNextLineParam("InetHost")) {
            inst.setInetHostName(input.readString("InetHost"));
        }
        if (input.isNextLineParam("InetPort")) {
            inst.setInetPort(input.readInt("InetPort"));
        }
    }

    private InstrumentConfig loadInstrument(SimpleParser input) throws IOException {
        if (input.isNextLineParam("Prototype")) {
            String prototypeName = input.readString("Prototype");
            InstrumentPrototype ip = this.instrumentTypes.get(prototypeName);
            if (ip == null) {
                throw input.IOX("Undefined InstrumentPrototype " + prototypeName);
            }
            int sn = input.readInt("SerialNumber");
            InstrumentConfig ic = new InstrumentConfig(ip, sn);
            this.customizeInstrument(input, ic, true);
            return ic;
        }
        if (input.isNextLineParam("Model")) {
            String model = input.readString("Model");
            int sn = input.readInt("SerialNumber");
            InstrumentPrototype ip = this.loadInstrumentType(input, "none", model);
            InstrumentConfig ic = new InstrumentConfig(ip, sn);
            this.customizeInstrument(input, ic, false);
            return ic;
        }
        throw input.IOX("Expecting Prototype or Model, got " + input.peekLine());
    }

    private int readCalSource(SimpleParser input, String keyword) throws IOException {
        String source = input.readString(keyword);
        if (source.equals("HRD")) {
            return 0;
        }
        if (source.equals("Trident")) {
            return 1;
        }
        throw input.IOX(String.valueOf(keyword) + " must be HRD or Trident");
    }

    private SensorConfig loadSensor(SimpleParser input) throws IOException {
        return new SensorConfig(input.readString("TypeName"), input.readString("Model"), input.readString("SensitivityUnits"), input.readDouble("Sensitivity"), input.readDouble("SensitivityFreq"), input.readString("CalibrationUnits"), input.readDouble("CalCoilResistance"), input.readDouble("CalCoilConstant"), input.readInt("CalEnable"), input.readInt("CalRelay"), input.readInt("MassCenterEnable"), input.readInt("MassCenterDuration"), this.readCalSource(input, "CalSource"));
    }

    private StationConfig loadStation(SimpleParser input) throws IOException {
        return new StationConfig(input.readString("Name"), input.readString("Description"), input.readDouble("Latitude"), input.readDouble("Longitude"), input.readDouble("Elevation"), this.network);
    }

    private DetectorType loadDetector(SimpleParser input) throws IOException {
        return new DetectorType(input.readString("Name"), input.readInt("TypeID"), input.readInt("CompletionDelay"), input.readInt("HighPassOrder"), input.readDouble("HighPassCornerHz"), input.readInt("LowPassOrder"), input.readDouble("LowPassCornerHz"), input.readDouble("StaConstant"), input.readDouble("LtaConstant"), input.readDouble("TriggerRatio"), input.readDouble("EarlyReportDelay"));
    }

    private TriggerConfig loadTrigger(SimpleParser input) throws IOException {
        String type = input.readString("Type");
        DetectorType detector = this.detectors.get(type);
        if (detector == null) {
            throw input.IOX("Undefined trigger type: " + type);
        }
        String chan = input.readString("Channel");
        if (!this.channels.contains(chan)) {
            throw input.IOX("Undefined trigger channel: " + chan);
        }
        double ratio = 0.0;
        if (input.isNextLineParam("TriggerRatio")) {
            ratio = input.readDouble("TriggerRatio");
        }
        return new TriggerConfig(detector, chan, 0, ratio);
    }

    public ChannelList getChannelList() {
        ChannelList list = new ChannelList();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            ChannelConfig chan = (ChannelConfig)e.nextElement();
            list.addElement(chan.getKey(), chan.getDottedName());
        }
        return list;
    }

    public CalibrationInfoTable getCalibrationTable() {
        CalibrationInfoTable calTable = new CalibrationInfoTable();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            ChannelConfig chan = (ChannelConfig)e.nextElement();
            if (chan.getType() != 1) continue;
            calTable.add(new CalibrationInfo(chan.getKey(), chan.getDottedName(), chan.getMassCenterEnable(), chan.getMassCenterDuration(), chan.getCalEnable(), chan.getCalRelay(), chan.getCalibrationUnits(), chan.getCalCoilResistance(), chan.getCalCoilConstant(), chan.getSensorType(), chan.getCalibrationSource()));
        }
        return calTable;
    }

    public Vector getTriggers() {
        Vector<TriggerConfig> validTrigs = new Vector<TriggerConfig>();
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerConfig trig = (TriggerConfig)e.nextElement();
            int key = this.channels.findKeyOf(trig.getDottedName());
            if (key == 0) continue;
            trig.setKey(key);
            validTrigs.addElement(trig);
        }
        return validTrigs;
    }

    public DetectorType getDetector(int type) {
        return this.detectors.get(type);
    }

    public Vector getStations() {
        Vector cv = new Vector();
        Enumeration e = this.stations.elements();
        while (e.hasMoreElements()) {
            cv.addElement(e.nextElement());
        }
        return cv;
    }

    public Vector getChannels() {
        Vector cv = new Vector();
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            cv.addElement(e.nextElement());
        }
        return cv;
    }

    public Vector getInstruments() {
        Vector inv = new Vector();
        Enumeration e = this.instruments.elements();
        while (e.hasMoreElements()) {
            inv.addElement(e.nextElement());
        }
        return inv;
    }

    public String getNetworkTag() {
        if (this.network != null) {
            String name = String.valueOf(this.network.getNetworkID()) + "   ";
            return String.valueOf(name.substring(0, 3)) + "-" + this.network.getNaqsID() + " ";
        }
        return "-NAQS-";
    }
}

