/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.naqs.stndb;

import ca.nanometrics.naqs.stndb.DetectorType;
import ca.nanometrics.naqs.stndb.StaLtaDetectorConfig;

public class TriggerConfig
implements StaLtaDetectorConfig {
    private String dottedName;
    private int key = 0;
    private DetectorType defn;
    private double triggerRatio;

    public TriggerConfig(DetectorType detectorType, String dottedChannelName, int aKey, double ratio) {
        this.dottedName = dottedChannelName;
        this.defn = detectorType;
        this.key = aKey;
        this.triggerRatio = ratio;
    }

    public TriggerConfig(DetectorType detectorType, String dottedChannelName, int aKey) {
        this(detectorType, dottedChannelName, aKey, 0.0);
    }

    public int getKey() {
        return this.key;
    }

    public String getDottedName() {
        return this.dottedName;
    }

    public String getTriggerName() {
        return this.defn.getName();
    }

    public int getTriggerType() {
        return this.defn.getType();
    }

    public int getStcDelay() {
        return this.defn.getStcDelay();
    }

    public int getHpOrder() {
        return this.defn.getHpOrder();
    }

    public double getHpCornerHz() {
        return this.defn.getHpCornerHz();
    }

    public int getLpOrder() {
        return this.defn.getLpOrder();
    }

    public double getLpCornerHz() {
        return this.defn.getLpCornerHz();
    }

    public double getStaConstant() {
        return this.defn.getStaConstant();
    }

    public double getLtaConstant() {
        return this.defn.getLtaConstant();
    }

    public double getTriggerRatio() {
        if (this.triggerRatio > 0.0) {
            return this.triggerRatio;
        }
        return this.defn.getTriggerRatio();
    }

    public double getEarlyReportDelay() {
        return this.defn.getEarlyReportDelay();
    }

    public void setKey(int aKey) {
        this.key = aKey;
    }
}

