/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;

public class PersistentMulticastSocket
extends MulticastSocket {
    private int rejoinInterval;
    private long timeOfLastJoin;
    private boolean multiHomed = false;
    private LinkedList groups = new LinkedList();

    public PersistentMulticastSocket(int port, int rejoinMillis, boolean multi) throws IOException {
        super(port);
        this.setRejoinInterval(rejoinMillis);
        this.setMultiHomed(multi);
        this.timeOfLastJoin = System.currentTimeMillis();
    }

    public PersistentMulticastSocket(int port) throws IOException {
        this(port, 0, false);
    }

    public PersistentMulticastSocket(int port, int rejoinMillis) throws IOException {
        this(port, rejoinMillis, false);
    }

    private SocketAddress getSocketAddress(InetAddress addr) {
        return new InetSocketAddress(addr, this.getLocalPort());
    }

    private boolean isValid(NetworkInterface netif) {
        return netif.getInetAddresses().hasMoreElements();
    }

    private void joinGroupMH(InetAddress addr) throws IOException {
        if (!addr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        SocketAddress sockaddr = this.getSocketAddress(addr);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface netif = enumeration.nextElement();
            if (!this.isValid(netif)) continue;
            try {
                this.joinGroup(sockaddr, netif);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void leaveGroupMH(InetAddress addr) throws IOException {
        if (!addr.isMulticastAddress()) {
            throw new SocketException("Not a multicast address");
        }
        SocketAddress sockaddr = this.getSocketAddress(addr);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface netif = enumeration.nextElement();
            if (!this.isValid(netif)) continue;
            try {
                this.leaveGroup(sockaddr, netif);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void leaveGroupEx(InetAddress addr) throws IOException {
        if (this.multiHomed) {
            this.leaveGroupMH(addr);
        } else {
            super.leaveGroup(addr);
        }
    }

    private void joinGroupEx(InetAddress addr) throws IOException {
        if (this.multiHomed) {
            this.joinGroupMH(addr);
        } else {
            super.joinGroup(addr);
        }
    }

    public void joinGroup(InetAddress addr) throws IOException {
        this.joinGroupEx(addr);
        if (!this.groups.contains(addr)) {
            this.groups.add(addr);
        }
    }

    public void leaveGroup(InetAddress addr) throws IOException {
        this.groups.remove(addr);
        this.leaveGroupEx(addr);
    }

    protected void rejoinAll() {
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            InetAddress addr = (InetAddress)iter.next();
            try {
                this.leaveGroupEx(addr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.joinGroupEx(addr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRejoinInterval(int millis) {
        this.rejoinInterval = millis;
    }

    public void setMultiHomed(boolean multi) {
        this.multiHomed = multi;
    }

    public void receive(DatagramPacket dp) throws IOException {
        long now;
        int millisSinceJoin;
        if (this.rejoinInterval > 0 && (millisSinceJoin = (int)((now = System.currentTimeMillis()) - this.timeOfLastJoin & Integer.MAX_VALUE)) > this.rejoinInterval) {
            this.rejoinAll();
            this.timeOfLastJoin = now;
        }
        super.receive(dp);
    }
}

