/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.util.Log;
import java.util.LinkedList;
import java.util.ListIterator;

public class CompletionBuffer
implements NmxPacketHandler {
    private static final int INIT_SEQUENCE_NUM = -1;
    private static final int MAX_TIME_DIFF = 600;
    static final int RX_DISCARD_LIMIT = 20;
    private int key;
    private int maxDelay;
    private NmxPacketHandler handler;
    private LinkedList buffer;
    private int expectedSeq;
    private double lastPacketTime;
    private int rxSinceAccept = 0;

    public CompletionBuffer(int theKey, int theMaxDelay, NmxPacketHandler theHandler) {
        this.key = theKey;
        this.maxDelay = theMaxDelay;
        this.handler = theHandler;
        this.buffer = new LinkedList();
        this.expectedSeq = -1;
        this.lastPacketTime = 0.0;
    }

    private void forward(NmxPacket pkt) {
        this.handler.put(pkt);
        this.expectedSeq = pkt.getSequenceNumber() + 1;
        this.lastPacketTime = pkt.getPacketTime();
        this.rxSinceAccept = 0;
    }

    private void store(NmxPacket newPacket) {
        int seqNum = newPacket.getSequenceNumber();
        ListIterator<NmxPacket> iter = this.buffer.listIterator();
        while (iter.hasNext()) {
            NmxPacket nextPacket = (NmxPacket)iter.next();
            int nextSeqNum = nextPacket.getSequenceNumber();
            if (seqNum == nextSeqNum) {
                return;
            }
            if (seqNum >= nextSeqNum) continue;
            iter.previous();
            break;
        }
        iter.add(newPacket);
    }

    private void sendBufferedPackets() {
        while (this.buffer.size() > 0) {
            NmxPacket nextPacket = (NmxPacket)this.buffer.getFirst();
            if (nextPacket.getSequenceNumber() != this.expectedSeq) break;
            this.forward(nextPacket);
            this.buffer.removeFirst();
        }
    }

    private void sendTimedOutPackets() {
        if (this.buffer.size() > 0) {
            NmxPacket lastPacket = (NmxPacket)this.buffer.getLast();
            double packetTime = lastPacket.getPacketTime();
            double minPktTime = System.currentTimeMillis() - 600L;
            double sendThreshold = Math.max(packetTime, minPktTime) - (double)this.maxDelay;
            Log.report(this, 4, 9999, "lastPktTime: " + packetTime + ", minPktTime: " + minPktTime + ", sendThreshold: " + sendThreshold);
            while (this.buffer.size() > 0) {
                NmxPacket nextPacket = (NmxPacket)this.buffer.getFirst();
                Log.report(this, 4, 9999, "Next pkt time: " + nextPacket.getPacketTime() + " string: " + nextPacket.getPacketTimeString());
                if (!(nextPacket.getPacketTime() < sendThreshold)) break;
                this.forward(nextPacket);
                this.buffer.removeFirst();
            }
        }
    }

    private void checkBuffer() {
        if (this.buffer.size() > 0) {
            try {
                this.sendBufferedPackets();
                this.sendTimedOutPackets();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean willForward(NmxPacket pkt) {
        return this.key == pkt.getKey() && (pkt.getSequenceNumber() >= this.expectedSeq || pkt.getPacketTime() > this.lastPacketTime);
    }

    public void put(NmxPacket newPacket) {
        if (this.key == newPacket.getKey()) {
            double packetTime;
            int seqNum = newPacket.getSequenceNumber();
            if (this.expectedSeq == -1) {
                if (newPacket.isReTx()) {
                    return;
                }
                this.expectedSeq = seqNum;
            }
            if (seqNum == this.expectedSeq) {
                this.forward(newPacket);
                this.checkBuffer();
            } else if (seqNum > this.expectedSeq) {
                this.store(newPacket);
                this.checkBuffer();
            } else if (seqNum < this.expectedSeq && ((packetTime = newPacket.getPacketTime()) > this.lastPacketTime || !newPacket.isReTx() && ++this.rxSinceAccept > 20)) {
                this.buffer.clear();
                this.forward(newPacket);
            }
        }
    }

    public void tick() {
        this.checkBuffer();
    }
}

