/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;

public class DecompDataPacket
extends Packet {
    public static final int MSG_TYPE = 4;
    static final int KEY_POSITION = 0;
    static final int TIME_POSITION = 4;
    static final int COUNT_POSITION = 12;
    static final int RATE_POSITION = 16;
    static final int DATA_POSITION = 20;
    int key;
    double startTime;
    int[] samples;
    int numSamples;
    int sampleRate;

    public DecompDataPacket(int theKey, double theStartTime, int[] theSamples, int numberOfSamples, int theSampleRate) {
        this.key = theKey;
        this.startTime = theStartTime;
        this.numSamples = numberOfSamples;
        this.sampleRate = theSampleRate;
        this.samples = new int[numberOfSamples];
        System.arraycopy(theSamples, 0, this.samples, 0, numberOfSamples);
    }

    public DecompDataPacket(DataPacket packet) {
        this.key = packet.getKey();
        this.startTime = packet.getStartTime();
        this.samples = packet.getSamples();
        this.numSamples = this.samples.length;
        this.sampleRate = packet.getSampleRate();
    }

    public DecompDataPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset + 0, this.key);
        BigEndian.writeDouble(buffer, offset + 4, this.startTime);
        BigEndian.writeInt(buffer, offset + 12, this.numSamples);
        BigEndian.writeInt(buffer, offset + 16, this.sampleRate);
        offset += 20;
        int ix = 0;
        while (ix < this.numSamples) {
            BigEndian.writeInt(buffer, offset, this.samples[ix]);
            offset += 4;
            ++ix;
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.key = BigEndian.readInt(buffer, offset + 0);
        this.startTime = BigEndian.readDouble(buffer, offset + 4);
        this.numSamples = BigEndian.readInt(buffer, offset + 12);
        this.sampleRate = BigEndian.readInt(buffer, offset + 16);
        if (length != this.getDataLength()) {
            throw new InvalidInputException("DecompDataPacket");
        }
        this.samples = new int[this.numSamples];
        offset += 20;
        int ix = 0;
        while (ix < this.numSamples) {
            this.samples[ix] = BigEndian.readInt(buffer, offset);
            offset += 4;
            ++ix;
        }
    }

    public int getDataType() {
        return 4;
    }

    public int getDataLength() {
        return 20 + 4 * this.numSamples;
    }

    public int getKey() {
        return this.key;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int[] getSamples() {
        int[] clonedSamples = new int[this.numSamples];
        System.arraycopy(this.samples, 0, clonedSamples, 0, this.numSamples);
        return clonedSamples;
    }

    public String toString() {
        Format ufmt = new Format("%03d");
        Format mfmt = new Format("%02d");
        Format sfmt = new Format("%06.3f");
        int ID = this.getKey() >> 16;
        int model = Instrument.getModelOf(ID);
        int unit = Instrument.getUnitOf(ID);
        int chan = 1 + (this.getKey() & 0xFF);
        int sec = (int)this.getStartTime();
        String str = String.valueOf(Instrument.getModelNameOf(model)) + ufmt.form(unit) + "-" + chan + " @ " + mfmt.form(sec % 3600 / 60) + ":" + sfmt.form(this.getStartTime() % 60.0) + "  " + this.getNumSamples() + " samples at " + this.getSampleRate() + " sps";
        return str;
    }
}

