/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.NmxDateFormat;

public class EventPacket
extends Packet {
    public static final int MSG_TYPE = 6;
    private static final NmxDateFormat dateFormat = new NmxDateFormat();
    private static final int INT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private static final int NAME_SIZE = 12;
    private int eventType;
    private int triggerType;
    private double start;
    private double duration;
    private String[] chnlNames;

    public EventPacket(int theEventType, int theTriggerType, double startTime, double durationOfPacket, String[] channelNames) {
        this.eventType = theEventType;
        this.triggerType = theTriggerType;
        this.start = startTime;
        this.duration = durationOfPacket;
        this.chnlNames = channelNames;
    }

    public EventPacket(byte[] buffer, int offset, int length) {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 6;
    }

    public int getDataLength() {
        return 28 + this.chnlNames.length * 12;
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.eventType);
        BigEndian.writeInt(buffer, offset += 4, this.triggerType);
        BigEndian.writeDouble(buffer, offset += 4, this.start);
        BigEndian.writeDouble(buffer, offset += 8, this.duration);
        BigEndian.writeInt(buffer, offset += 8, this.chnlNames.length);
        offset += 4;
        int i = 0;
        while (i < this.chnlNames.length) {
            BigEndian.writeString(buffer, offset, this.chnlNames[i], 12);
            offset += 12;
            ++i;
        }
    }

    public void readFrom(byte[] buffer, int offset, int length) {
        this.eventType = BigEndian.readInt(buffer, offset);
        this.triggerType = BigEndian.readInt(buffer, offset += 4);
        this.start = BigEndian.readDouble(buffer, offset += 4);
        this.duration = BigEndian.readDouble(buffer, offset += 8);
        int trigCount = BigEndian.readInt(buffer, offset += 8);
        this.chnlNames = new String[trigCount];
        offset += 4;
        int i = 0;
        while (i < trigCount) {
            this.chnlNames[i] = BigEndian.readString(buffer, offset, 12);
            offset += 12;
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Event-");
        sb.append(this.getTrigType());
        sb.append("/");
        sb.append(this.getEventType());
        sb.append(" " + dateFormat.format(this.getStart()));
        sb.append(" dur: " + this.getDuration());
        sb.append(" trigs: " + this.getTrigCount());
        return sb.toString();
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getTrigType() {
        return this.triggerType;
    }

    public double getStart() {
        return this.start;
    }

    public double getDuration() {
        return this.duration;
    }

    public int getTrigCount() {
        return this.chnlNames.length;
    }

    public String[] getNames() {
        return this.chnlNames;
    }
}

