/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.util.Format;

public class Instrument {
    public static final int HRD = 0;
    public static final int ORION = 1;
    public static final int RM3 = 2;
    public static final int RM4 = 3;
    public static final int LYNX = 4;
    public static final int CYGNUS = 5;
    public static final int EUROPA = 6;
    public static final int CARINA = 7;
    public static final int TIMESERVER = 8;
    public static final int TRIDENT = 9;
    public static final int JANUS = 10;
    public static final int TAURUS = 11;
    public static final int APOLLO = 12;
    public static final int TRIDENT305 = 13;
    public static final int CARINA105 = 14;
    public static final int CYGNUS205 = 15;
    public static final String[] modelName = new String[]{"HRD", "Orion", "RM3", "RM4", "LYNX", "Cygnus", "Europa", "Carina", "TimeServer", "Trident", "Janus", "Taurus", "Apollo", "Trident305", "Carina105", "Cygnus205"};
    static final String[] shortName = new String[]{"HRD", "ORN", "RM3", "RM4", "LNX", "CYG", "EUR", "CAR", "TIM", "TRI", "JAN", "TAU", "APO", "305", "105", "205"};
    static final String unknownModel = "UNK";
    static final int UNIT_MASK = 2047;
    static final int MODEL_MASK = 63488;
    static final int MODEL_SHIFT = 11;

    public static String getModelNameFromId(int id) {
        return Instrument.getModelNameOf(Instrument.getModelOf(id));
    }

    public static String getModelNameOf(int model) {
        if (model >= 0 && model < modelName.length) {
            return modelName[model];
        }
        return unknownModel;
    }

    protected static String getShortNameOf(int model) {
        if (model >= 0 && model < modelName.length) {
            return shortName[model];
        }
        return unknownModel;
    }

    public static int getModelOf(String name) {
        int i = 0;
        while (i < modelName.length) {
            if (name.equalsIgnoreCase(modelName[i]) || name.equalsIgnoreCase(Instrument.getShortNameOf(i))) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < shortName.length) {
            if (name.equalsIgnoreCase(shortName[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIDOf(String model, int unit) {
        return Instrument.getIDOf(Instrument.getModelOf(model), unit);
    }

    public static int getIDOf(int model, int unit) {
        return model << 11 & 0xF800 | unit & 0x7FF;
    }

    public static int getModelOf(int id) {
        return (id & 0xF800) >> 11;
    }

    public static int getUnitOf(int id) {
        return id & 0x7FF;
    }

    public static String getNameOf(int id) {
        int unit = Instrument.getUnitOf(id);
        Format fmt = new Format("%03d");
        return String.valueOf(Instrument.getShortNameOf(Instrument.getModelOf(id))) + fmt.form(unit);
    }

    public static String getFullNameOf(int id) {
        int unit = Instrument.getUnitOf(id);
        return String.valueOf(Instrument.getModelNameOf(Instrument.getModelOf(id))) + " " + unit;
    }

    public static boolean hasInternalHrd(int id) {
        int model = Instrument.getModelOf(id);
        return model == 0 || model == 1 || model == 4 || model == 6;
    }

    public static boolean isVSat(int id) {
        int model = Instrument.getModelOf(id);
        return model == 7 || model == 5 || model == 4;
    }

    public static boolean isVSatRemote(int id) {
        int model = Instrument.getModelOf(id);
        return model == 5 || model == 4;
    }

    public static boolean isNmxBusDevice(int id) {
        int model = Instrument.getModelOf(id);
        return model == 8 || model == 9;
    }

    public static boolean isController(int id) {
        int model = Instrument.getModelOf(id);
        return model == 7 || model == 5 || model == 4 || model == 6 || model == 10;
    }

    public static boolean isTaurus(int id) {
        int model = Instrument.getModelOf(id);
        return model == 11;
    }
}

