/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.BigEndian;

public class InternetPacketWrapper
extends PacketWrapper {
    public static final int NMX_SIGNATURE = 2059197967;
    static final int SIGNATURE_OFFSET = 0;
    static final int DATA_TYPE_OFFSET = 4;
    static final int DATA_LEN_OFFSET = 8;
    private static final int OFFSET_TO_DATA = 12;

    public byte[] makeWrappedPacket(Packable packet) {
        int dataLen = packet.getDataLength();
        int length = 12 + dataLen;
        byte[] buffer = new byte[length];
        this.writeUDPHeader(buffer, packet.getDataType(), packet.getDataLength());
        packet.writeTo(buffer, 12);
        return buffer;
    }

    private void writeUDPHeader(byte[] buffer, int type, int len) {
        BigEndian.writeInt(buffer, 0, 2059197967);
        BigEndian.writeInt(buffer, 4, type);
        BigEndian.writeInt(buffer, 8, len);
    }

    public byte[] makeWrappedPacket(byte[] bytes, int type) {
        int length = 12 + bytes.length;
        byte[] buffer = new byte[length];
        this.writeUDPHeader(buffer, type, bytes.length);
        System.arraycopy(bytes, 0, buffer, 12, bytes.length);
        return buffer;
    }

    public boolean isValidPacket(byte[] buffer, int length) {
        return BigEndian.readInt(buffer, 0) == 2059197967 && BigEndian.readInt(buffer, 8) + 12 == length;
    }

    public int getDataOffset() {
        return 12;
    }

    public static int getDataOffsetAsClassConst() {
        return 12;
    }

    public int getDataType(byte[] buffer) {
        return BigEndian.readInt(buffer, 4);
    }

    public int getDataLength(byte[] buffer) {
        return BigEndian.readInt(buffer, 8);
    }
}

