/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.FillerPacket;
import ca.nanometrics.packet.LogPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketBuilder;
import ca.nanometrics.packet.SerialPacket;
import ca.nanometrics.packet.SohPacket;
import ca.nanometrics.packet.TimeSyncPacket;
import ca.nanometrics.util.InvalidInputException;

public class NmxPacketFactory {
    static final int DATA_PACKET = 1;
    static final int SOH_PACKET = 2;
    static final int TIME_PACKET = 4;
    static final int LOG_PACKET = 5;
    static final int SERIAL_PACKET = 6;
    static final int FILLER_PACKET = 9;
    private static NmxPacketBuilder[] builders;
    private static NmxPacketBuilder defaultBuilder;

    private static void initialize() {
        int numBuilders = 32;
        defaultBuilder = new NmxPacketBuilder();
        builders = new NmxPacketBuilder[numBuilders];
        int ix = 0;
        while (ix < numBuilders) {
            NmxPacketFactory.builders[ix] = defaultBuilder;
            ++ix;
        }
    }

    public static NmxPacketBuilder getBuilder(int type) {
        if (builders == null) {
            NmxPacketFactory.setStandardBuilders();
        }
        if (type >= 0 && type < builders.length) {
            return builders[type];
        }
        return defaultBuilder;
    }

    public static void setBuilder(int type, NmxPacketBuilder builder) {
        if (builders == null) {
            NmxPacketFactory.initialize();
        }
        if (type >= 0 && type < builders.length && builder != null) {
            NmxPacketFactory.builders[type] = builder;
        }
    }

    private static void setStandardBuilders() {
        NmxPacketFactory.setBuilder(1, new DataPacketBuilder());
        NmxPacketFactory.setBuilder(2, new SohPacketBuilder());
        NmxPacketFactory.setBuilder(6, new SerialPacketBuilder());
        NmxPacketFactory.setBuilder(5, new LogPacketBuilder());
        NmxPacketFactory.setBuilder(4, new TimePacketBuilder());
        NmxPacketFactory.setBuilder(9, new FillerPacketBuilder());
    }

    public static NmxPacket makePacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        try {
            int type = NmxPacket.readTypeFrom(buffer, offset);
            return NmxPacketFactory.getBuilder(type).createPacket(buffer, offset, length);
        }
        catch (Exception any) {
            throw new InvalidInputException("Error in NmxPacketFactory:" + NmxPacket.readTypeFrom(buffer, offset));
        }
    }

    public static NmxPacket makePacket(byte[] buffer, int oldest) throws InvalidInputException {
        try {
            int type = NmxPacket.getNmxpType(buffer);
            return NmxPacketFactory.getBuilder(type).createPacket(buffer, oldest);
        }
        catch (Exception e) {
            throw new InvalidInputException("Error in NmxPacketFactory:" + NmxPacket.getNmxpType(buffer));
        }
    }

    public static NmxPacket makePacket(byte[] buffer) throws InvalidInputException {
        return NmxPacketFactory.makePacket(buffer, 0);
    }

    private static class DataPacketBuilder
    extends NmxPacketBuilder {
        private DataPacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new DataPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new DataPacket(buffer, oldest);
        }
    }

    private static class FillerPacketBuilder
    extends NmxPacketBuilder {
        private FillerPacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new FillerPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new FillerPacket(buffer, oldest);
        }
    }

    private static class LogPacketBuilder
    extends NmxPacketBuilder {
        private LogPacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new LogPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new LogPacket(buffer, oldest);
        }
    }

    private static class SerialPacketBuilder
    extends NmxPacketBuilder {
        private SerialPacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new SerialPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new SerialPacket(buffer, oldest);
        }
    }

    private static class SohPacketBuilder
    extends NmxPacketBuilder {
        private SohPacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new SohPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new SohPacket(buffer, oldest);
        }
    }

    private static class TimePacketBuilder
    extends NmxPacketBuilder {
        private TimePacketBuilder() {
        }

        public NmxPacket createPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
            return new TimeSyncPacket(buffer, offset, length);
        }

        public NmxPacket createPacket(byte[] buffer, int oldest) throws InvalidInputException {
            return new TimeSyncPacket(buffer, oldest);
        }
    }
}

