/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OldCompletionBuffer
implements NmxPacketHandler {
    private static int INIT_SEQUENCE_NUM = -1;
    private int key;
    private int maxDelay;
    private NmxPacketHandler handler;
    private LinkedList InsertBuffer;
    private int expectedSeq;
    private double lastPacketTime;

    public OldCompletionBuffer(int key, int maxDelay, NmxPacketHandler handler) {
        this.key = key;
        this.maxDelay = maxDelay;
        this.handler = handler;
        this.InsertBuffer = new LinkedList();
        this.expectedSeq = INIT_SEQUENCE_NUM;
        this.lastPacketTime = 0.0;
    }

    private void forward(NmxPacket pkt) {
        this.handler.put(pkt);
        this.expectedSeq = pkt.getSequenceNumber() + 1;
        this.lastPacketTime = pkt.getPacketTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(NmxPacket newPacket) {
        if (this.key == newPacket.getKey()) {
            int seqNum = newPacket.getSequenceNumber();
            if (this.expectedSeq == INIT_SEQUENCE_NUM) {
                if (newPacket.isReTx()) {
                    return;
                }
                this.expectedSeq = seqNum;
            }
            if (seqNum == this.expectedSeq) {
                this.forward(newPacket);
                this.sendBufferedPackets();
            } else if (seqNum < this.expectedSeq) {
                double packetTime = newPacket.getPacketTime();
                if (packetTime > this.lastPacketTime) {
                    this.forward(newPacket);
                    this.InsertBuffer.clear();
                }
            } else if (seqNum > this.expectedSeq) {
                LinkedList linkedList = this.InsertBuffer;
                synchronized (linkedList) {
                    ListIterator<NmxPacket> iter = this.InsertBuffer.listIterator(0);
                    while (iter.hasNext()) {
                        NmxPacket nextPacket = (NmxPacket)iter.next();
                        int nextSeqNum = nextPacket.getSequenceNumber();
                        if (seqNum == nextSeqNum) {
                            return;
                        }
                        if (seqNum >= nextSeqNum) continue;
                        iter.previous();
                        break;
                    }
                    iter.add(newPacket);
                }
            }
        }
    }

    public boolean willForward(NmxPacket pkt) {
        return this.key == pkt.getKey() && (pkt.getSequenceNumber() >= this.expectedSeq || pkt.getPacketTime() > this.lastPacketTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBufferedPackets() {
        LinkedList linkedList = this.InsertBuffer;
        synchronized (linkedList) {
            try {
                while (this.InsertBuffer.size() > 0) {
                    NmxPacket nextPacket = (NmxPacket)this.InsertBuffer.getFirst();
                    if (nextPacket.getSequenceNumber() == this.expectedSeq) {
                        this.forward(nextPacket);
                        this.InsertBuffer.removeFirst();
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTimedOutPackets() {
        double currentTime = 0.001 * (double)System.currentTimeMillis();
        LinkedList linkedList = this.InsertBuffer;
        synchronized (linkedList) {
            try {
                while (this.InsertBuffer.size() > 0) {
                    NmxPacket nextPacket = (NmxPacket)this.InsertBuffer.getFirst();
                    if (currentTime - nextPacket.getPacketTime() > (double)this.maxDelay) {
                        this.forward(nextPacket);
                        this.InsertBuffer.removeFirst();
                        continue;
                    }
                    break;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public void tick() {
        if (this.InsertBuffer.size() > 0) {
            this.sendTimedOutPackets();
            this.sendBufferedPackets();
        }
    }
}

