/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;

public class RawPacket
extends Packet {
    public static final int MSG_TYPE = 20;
    public static final int INT_SIZE = 4;
    private int bodyType;
    private int bodyLength;
    byte[] body;

    public RawPacket(int type, int length, byte[] buffer) throws InvalidInputException {
        if (length < 0) {
            throw new InvalidInputException("RawPacket length < 0");
        }
        if (buffer == null && length > 0) {
            throw new InvalidInputException("RawPacket buffer is null");
        }
        this.bodyType = type;
        this.bodyLength = length;
        this.body = new byte[this.bodyLength];
        if (length > 0) {
            System.arraycopy(this.body, 0, buffer, 0, this.bodyLength);
        }
    }

    public RawPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 20;
    }

    public int getDataLength() {
        return 4 + this.bodyLength;
    }

    public int getBodyType() {
        return this.bodyType;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void writeTo(byte[] dest, int offset) {
        BigEndian.writeInt(dest, offset, this.bodyType);
        System.arraycopy(this.body, 0, dest, offset + 4, this.body.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length < 4) {
            throw new InvalidInputException("RawPacket length < 4 bytes");
        }
        this.bodyType = BigEndian.readInt(buffer, offset);
        this.bodyLength = length - 4;
        if (this.bodyLength > 0) {
            this.body = new byte[this.bodyLength];
            System.arraycopy(buffer, offset + 4, this.body, 0, this.bodyLength);
        } else {
            this.body = null;
        }
    }

    public String toString() {
        String str = "RawPacket type " + this.bodyType + ", length " + this.bodyLength;
        return str;
    }
}

