/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class StaLtaTrigger
extends TriggerPacket {
    private static final int SIZEOF_STNID = 12;
    private static final int OFFSET_TO_STNID = 0;
    private static final int OFFSET_TO_ID = 12;
    private static final int OFFSET_TO_TIME = 16;
    private static final int OFFSET_TO_DURATION = 24;
    private static final int OFFSET_TO_LTA_START = 28;
    private static final int OFFSET_TO_LTA_END = 32;
    private static final int OFFSET_TO_PEAK_STA = 36;
    private static final int OFFSET_TO_PEAK_TO_PEAK = 40;
    private static final int OFFSET_TO_TIME_TO_PEAK = 44;
    private static final int OFFSET_TO_HALF_PERIOD = 48;
    private static final int OFFSET_TO_PHASE = 52;
    private static final int DATA_LENGTH = 56;
    protected static DateFormat dateFormat = null;
    String stnID;
    int triggerID;
    double startTime;
    float duration;
    float ltaAtStart;
    float ltaAtEnd;
    float peakSta;
    float maxPeakToPeak;
    float timeToPeak;
    float halfPeriod;
    int phase;

    public StaLtaTrigger(String stationId, int triggerId, double start, float theDuration, float longTermAvgAtStart1, float longTermAvgAtEnd, float peakShortTermAvg, float maxFromPeakToPeak, float theTimeToPeak, float theHalfPeriod, int thePhase) {
        this.stnID = stationId;
        this.triggerID = triggerId;
        this.startTime = start;
        this.duration = theDuration;
        this.ltaAtStart = longTermAvgAtStart1;
        this.ltaAtEnd = longTermAvgAtEnd;
        this.peakSta = peakShortTermAvg;
        this.maxPeakToPeak = maxFromPeakToPeak;
        this.timeToPeak = theTimeToPeak;
        this.halfPeriod = theHalfPeriod;
        this.phase = thePhase;
    }

    public StaLtaTrigger(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeString(buffer, offset + 0, this.stnID, 12);
        BigEndian.writeInt(buffer, offset + 12, this.triggerID);
        BigEndian.writeDouble(buffer, offset + 16, this.startTime);
        BigEndian.writeFloat(buffer, offset + 24, this.duration);
        BigEndian.writeFloat(buffer, offset + 28, this.ltaAtStart);
        BigEndian.writeFloat(buffer, offset + 32, this.ltaAtEnd);
        BigEndian.writeFloat(buffer, offset + 36, this.peakSta);
        BigEndian.writeFloat(buffer, offset + 40, this.maxPeakToPeak);
        BigEndian.writeFloat(buffer, offset + 44, this.timeToPeak);
        BigEndian.writeFloat(buffer, offset + 48, this.halfPeriod);
        BigEndian.writeInt(buffer, offset + 52, this.phase);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length != this.getDataLength() || buffer.length < offset + length) {
            throw new InvalidInputException("StaLtaTrigger");
        }
        this.stnID = BigEndian.readString(buffer, offset + 0, 12);
        this.triggerID = BigEndian.readInt(buffer, offset + 12);
        this.startTime = BigEndian.readDouble(buffer, offset + 16);
        this.duration = BigEndian.readFloat(buffer, offset + 24);
        this.ltaAtStart = BigEndian.readFloat(buffer, offset + 28);
        this.ltaAtEnd = BigEndian.readFloat(buffer, offset + 32);
        this.peakSta = BigEndian.readFloat(buffer, offset + 36);
        this.maxPeakToPeak = BigEndian.readFloat(buffer, offset + 40);
        this.timeToPeak = BigEndian.readFloat(buffer, offset + 44);
        this.halfPeriod = BigEndian.readFloat(buffer, offset + 48);
        this.phase = BigEndian.readInt(buffer, offset + 52);
    }

    public String startTimeString() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        long millis = (long)(1000.0 * this.startTime);
        return dateFormat.format(new Date(millis));
    }

    public String toString() {
        Format durFmt = new Format("%.3f");
        String str = String.valueOf(this.stnID) + "-" + this.triggerID + ":" + this.phase + "  " + this.startTimeString() + "  " + durFmt.form(this.duration);
        return str;
    }

    public int getDataLength() {
        return 56;
    }

    public String getStnID() {
        return this.stnID;
    }

    public int getTriggerID() {
        return this.triggerID;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getLtaAtStart() {
        return this.ltaAtStart;
    }

    public float getLtaAtEnd() {
        return this.ltaAtEnd;
    }

    public float getPeakSta() {
        return this.peakSta;
    }

    public float getMaxPeakToPeak() {
        return this.maxPeakToPeak;
    }

    public float getTimeToPeak() {
        return this.timeToPeak;
    }

    public float getHalfPeriod() {
        return this.halfPeriod;
    }

    public int getPhase() {
        return this.phase;
    }

    public float getPeakRatio() {
        float denominator = this.ltaAtStart > 0.0f ? this.ltaAtStart : 1.0f;
        return this.peakSta / denominator;
    }

    public String toFullString() {
        String sep = " : ";
        StringBuffer str = new StringBuffer();
        str.append(this.getStnID());
        str.append(String.valueOf(sep) + this.getTriggerID());
        str.append(String.valueOf(sep) + this.getStartTime());
        str.append(String.valueOf(sep) + this.getDuration());
        str.append(String.valueOf(sep) + this.getLtaAtStart());
        str.append(String.valueOf(sep) + this.getLtaAtEnd());
        str.append(String.valueOf(sep) + this.getPeakSta());
        str.append(String.valueOf(sep) + this.getMaxPeakToPeak());
        str.append(String.valueOf(sep) + this.getTimeToPeak());
        str.append(String.valueOf(sep) + this.getHalfPeriod());
        str.append(String.valueOf(sep) + this.getPhase());
        return str.toString();
    }
}

