/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class WNCalibrationCommandPacket
extends CalibrationCommandPacket {
    public static final byte SUB_TYPE = 4;
    private static final int OFFSET_TO_UNITPULSE = 0;
    private static final int OFFSET_TO_POLYMASK = 4;
    private static final int OFFSET_TO_SEED = 8;
    private static final int OFFSET_TO_BITS = 12;
    private static final int NUM_PARAMBYTES = 16;

    public WNCalibrationCommandPacket(int _timeSecs, int _instrumentID, byte _channelBits, byte _ctrlLines, byte _attenuation, byte _amplitudeUnit, float _amplitude, float _dcOffset, float _tOn, float _ramp, float _duration, String _identifier, int _unitPulseWidth, int _polynomialMask, int _seedValue, int _bits) {
        super(_timeSecs, _instrumentID, _channelBits, (byte)4, _ctrlLines, _attenuation, _amplitudeUnit, _amplitude, _dcOffset, _tOn, _ramp, _duration, _identifier, 16);
        this.setUnitPulseWidth(_unitPulseWidth);
        this.setPolynomialMask(_polynomialMask);
        this.setSeed(_seedValue);
        this.setBits(_bits);
    }

    public WNCalibrationCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public int getUnitPulseWidth() {
        int width = LittleEndian.readInt(this.paramBytes, 0);
        return width;
    }

    public int getPolynomialMask() {
        int mask = LittleEndian.readInt(this.paramBytes, 4);
        return mask;
    }

    public int getSeed() {
        int seed = LittleEndian.readInt(this.paramBytes, 8);
        return seed;
    }

    public int getBits() {
        int bits = LittleEndian.readInt(this.paramBytes, 12);
        return bits;
    }

    public void setUnitPulseWidth(int newUnitWidth) {
        LittleEndian.writeInt(this.paramBytes, 0, newUnitWidth);
    }

    public void setPolynomialMask(int newMask) {
        LittleEndian.writeInt(this.paramBytes, 4, newMask);
    }

    public void setSeed(int newSeed) {
        LittleEndian.writeInt(this.paramBytes, 8, newSeed);
    }

    public void setBits(int newBits) {
        LittleEndian.writeInt(this.paramBytes, 12, newBits);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.setNumParamBytes(16);
    }

    public String toString() {
        return "WNCalibrationCommand for instrument " + this.getInstrumentID();
    }
}

