/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CalibrationCommandPacketTest
extends TestCase {
    int timeSecs;
    int instrumentID;
    byte channelBits;
    byte subtype;
    byte ctrlLines;
    byte attenuation;
    float amplitude;
    byte amplitudeUnit;
    float dcOffset;
    float duration;
    float tOn;
    float ramp;
    String identifier;
    int numParamBytes;
    CalibrationCommandPacket packet;
    static /* synthetic */ Class class$0;

    public CalibrationCommandPacketTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.CalibrationCommandPacketTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        this.timeSecs = 10;
        this.instrumentID = 5;
        this.channelBits = 1;
        this.subtype = (byte)2;
        this.amplitudeUnit = (byte)3;
        this.ctrlLines = (byte)4;
        this.attenuation = 1;
        this.amplitude = 2.0f;
        this.dcOffset = 1.0f;
        this.duration = 30.3f;
        this.tOn = 12.0f;
        this.ramp = 12.3f;
        this.identifier = "test";
        this.numParamBytes = 0;
        this.packet = new CalibrationCommandPacket(this.timeSecs, this.instrumentID, this.channelBits, this.subtype, this.ctrlLines, this.attenuation, this.amplitudeUnit, this.amplitude, this.dcOffset, this.tOn, this.ramp, this.duration, this.identifier, this.numParamBytes);
    }

    public void testConstructor() throws Exception {
        CalibrationCommandPacketTest.assertNotNull((String)"null regular constructor", (Object)this.packet);
    }

    public void testGets() throws Exception {
        CalibrationCommandPacketTest.assertEquals((String)"getChannelBits()", (byte)this.channelBits, (byte)this.packet.getChannelBits());
        CalibrationCommandPacketTest.assertEquals((String)"getSubtype()", (byte)this.subtype, (byte)this.packet.getSubtype());
        CalibrationCommandPacketTest.assertEquals((String)"getCtrlLines()", (byte)this.ctrlLines, (byte)this.packet.getCtrlLines());
        CalibrationCommandPacketTest.assertEquals((String)"getAttenuation()", (byte)this.attenuation, (byte)this.packet.getAttenuation());
        CalibrationCommandPacketTest.assertEquals((String)"getAmplitudeUnit()", (byte)this.amplitudeUnit, (byte)this.packet.getAmplitudeUnit());
        CalibrationCommandPacketTest.assertEquals((String)"getAmplitude()", (double)this.amplitude, (double)this.packet.getAmplitude(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getDcOffset()", (double)this.dcOffset, (double)this.packet.getDcOffset(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getTOn()", (double)this.tOn, (double)this.packet.getTOn(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getRamp()", (double)this.ramp, (double)this.packet.getRamp(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getDuration()", (double)this.duration, (double)this.packet.getDuration(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getIdentifier()", (String)this.identifier, (String)this.packet.getIdentifier());
        CalibrationCommandPacketTest.assertEquals((String)"getNumParamBytes()", (int)this.numParamBytes, (int)this.packet.getNumParamBytes());
    }

    public void testSets() throws Exception {
        this.channelBits = (byte)2;
        this.packet.setChannelBits(this.channelBits);
        CalibrationCommandPacketTest.assertEquals((String)"setChannelBits()", (byte)this.channelBits, (byte)this.packet.getChannelBits());
        this.subtype = (byte)66;
        this.packet.setSubtype(this.subtype);
        CalibrationCommandPacketTest.assertEquals((String)"setSubtype()", (byte)this.subtype, (byte)this.packet.getSubtype());
        this.ctrlLines = (byte)114;
        this.packet.setCtrlLines(this.ctrlLines);
        CalibrationCommandPacketTest.assertEquals((String)"setCtrlLines()", (byte)this.ctrlLines, (byte)this.packet.getCtrlLines());
        this.attenuation = (byte)4;
        this.packet.setAttenuation(this.attenuation);
        CalibrationCommandPacketTest.assertEquals((String)"setAttenuation()", (byte)this.attenuation, (byte)this.packet.getAttenuation());
        this.amplitudeUnit = 1;
        this.packet.setAmplitudeUnit(this.amplitudeUnit);
        CalibrationCommandPacketTest.assertEquals((String)"setAmplitudeUnit()", (byte)this.amplitudeUnit, (byte)this.packet.getAmplitudeUnit());
        this.amplitude = 0.1f;
        this.packet.setAmplitude(this.amplitude);
        CalibrationCommandPacketTest.assertEquals((String)"setAmplitude()", (double)this.amplitude, (double)this.packet.getAmplitude(), (double)0.001);
        this.dcOffset = 0.1f;
        this.packet.setDcOffset(this.dcOffset);
        CalibrationCommandPacketTest.assertEquals((String)"setDcOffset()", (double)this.dcOffset, (double)this.packet.getDcOffset(), (double)0.001);
        this.tOn = 0.1f;
        this.packet.setTOn(this.tOn);
        CalibrationCommandPacketTest.assertEquals((String)"setTOn()", (double)this.tOn, (double)this.packet.getTOn(), (double)0.001);
        this.ramp = 0.1f;
        this.packet.setRamp(this.ramp);
        CalibrationCommandPacketTest.assertEquals((String)"setRamp()", (double)this.ramp, (double)this.packet.getRamp(), (double)0.001);
        this.duration = 0.1f;
        this.packet.setDuration(this.duration);
        CalibrationCommandPacketTest.assertEquals((String)"setDuration()", (double)this.duration, (double)this.packet.getDuration(), (double)0.001);
        this.identifier = "newID";
        this.packet.setIdentifier(this.identifier);
        CalibrationCommandPacketTest.assertEquals((String)"setIdentifier()", (String)this.identifier, (String)this.packet.getIdentifier());
        this.numParamBytes = 3;
        this.packet.setNumParamBytes(this.numParamBytes);
        CalibrationCommandPacketTest.assertEquals((String)"setNumParamBytes()", (int)this.numParamBytes, (int)this.packet.getNumParamBytes());
    }

    public void testPackable() throws Exception {
        byte[] buffer = new byte[this.packet.getDataLength() + 2];
        this.packet.writeTo(buffer, 2);
        CalibrationCommandPacket packedPacket = new CalibrationCommandPacket(buffer, 2, buffer.length);
        CalibrationCommandPacketTest.assertEquals((String)"getChannelBits()", (byte)this.channelBits, (byte)packedPacket.getChannelBits());
        CalibrationCommandPacketTest.assertEquals((String)"getSubtype()", (byte)this.subtype, (byte)packedPacket.getSubtype());
        CalibrationCommandPacketTest.assertEquals((String)"getCtrlLines()", (byte)this.ctrlLines, (byte)packedPacket.getCtrlLines());
        CalibrationCommandPacketTest.assertEquals((String)"getAttenuation()", (byte)this.attenuation, (byte)packedPacket.getAttenuation());
        CalibrationCommandPacketTest.assertEquals((String)"getAmplitudeUnit()", (byte)this.amplitudeUnit, (byte)packedPacket.getAmplitudeUnit());
        CalibrationCommandPacketTest.assertEquals((String)"getAmplitude()", (double)this.amplitude, (double)packedPacket.getAmplitude(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getDcOffset()", (double)this.dcOffset, (double)packedPacket.getDcOffset(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getTOn()", (double)this.tOn, (double)packedPacket.getTOn(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getRamp()", (double)this.ramp, (double)packedPacket.getRamp(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getDuration()", (double)this.duration, (double)packedPacket.getDuration(), (double)0.001);
        CalibrationCommandPacketTest.assertEquals((String)"getIdentifier()", (String)this.identifier, (String)packedPacket.getIdentifier());
        CalibrationCommandPacketTest.assertEquals((String)"getNumParamBytes()", (int)this.numParamBytes, (int)packedPacket.getNumParamBytes());
    }
}

