/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.CalibrationResponse;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CalibrationResponseTester
extends TestCase {
    private static float defaultCalib = 5.0f;
    private static float defaultCalper = 10.0f;
    private static String defaultChannel = "defaultChannel";
    private static String defaultStation = "Station";
    private static String defaultResponse = "defaultResponse";
    private static String defaultRecordID = "defaultRecordID";
    private static String defaultHandlerID = "defaultHandlerID";
    private static String defaultUserID = "defaultUserID";
    private static boolean defaultInSpec = false;
    private CalibrationResponse calResponse;
    static /* synthetic */ Class class$0;

    public CalibrationResponseTester(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.CalibrationResponseTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        this.calResponse = this.createDefaultCalibrationResponse();
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
    }

    public void testConstructor() throws Exception {
        CalibrationResponseTester.assertNotNull((String)"null CalibrationResponse on construct", (Object)this.calResponse);
    }

    private CalibrationResponse createDefaultCalibrationResponse() {
        return new CalibrationResponse(defaultCalib, defaultCalper, defaultStation, defaultChannel, defaultResponse, defaultRecordID, defaultHandlerID, defaultUserID, defaultInSpec);
    }

    public void testGets() throws Exception {
        CalibrationResponseTester.assertEquals((String)"Get defaultCalib incorrect", (double)defaultCalib, (double)this.calResponse.getCalib(), (double)0.1);
        CalibrationResponseTester.assertEquals((String)"Get defaultCalper incorrect", (double)defaultCalper, (double)this.calResponse.getCalper(), (double)0.1);
        CalibrationResponseTester.assertEquals((String)"Get defaultChannel incorrect", (String)defaultChannel, (String)this.calResponse.getChannel());
        CalibrationResponseTester.assertEquals((String)"Get defaultstation incorrect", (String)defaultStation, (String)this.calResponse.getStation());
        CalibrationResponseTester.assertEquals((String)"getResponse", (String)defaultResponse, (String)this.calResponse.getResponse());
        CalibrationResponseTester.assertEquals((String)"getRecordID", (String)defaultRecordID, (String)this.calResponse.getRecordID());
        CalibrationResponseTester.assertEquals((String)"getHandlerID", (String)defaultHandlerID, (String)this.calResponse.getHandlerID());
        CalibrationResponseTester.assertEquals((String)"getUserID", (String)defaultUserID, (String)this.calResponse.getUserID());
        CalibrationResponseTester.assertEquals((String)"getInSpec", (boolean)defaultInSpec, (boolean)this.calResponse.getInSpec());
    }

    public void testPackable() throws Exception {
        byte[] packetBytes = new byte[this.calResponse.getDataLength()];
        this.calResponse.writeTo(packetBytes, 0);
        CalibrationResponse readResponse = new CalibrationResponse(packetBytes, 0, packetBytes.length);
        CalibrationResponseTester.assertEquals((String)"Get defaultCalib incorrect", (double)defaultCalib, (double)readResponse.getCalib(), (double)0.1);
        CalibrationResponseTester.assertEquals((String)"Get defaultCalper incorrect", (double)defaultCalper, (double)readResponse.getCalper(), (double)0.1);
        CalibrationResponseTester.assertEquals((String)"Get defaultChannel incorrect", (String)defaultChannel, (String)readResponse.getChannel());
        CalibrationResponseTester.assertEquals((String)"Get defaultstation incorrect", (String)defaultStation, (String)readResponse.getStation());
        CalibrationResponseTester.assertEquals((String)"getResponse", (String)defaultResponse, (String)readResponse.getResponse());
        CalibrationResponseTester.assertEquals((String)"getRecordID", (String)defaultRecordID, (String)readResponse.getRecordID());
        CalibrationResponseTester.assertEquals((String)"getHandlerID", (String)defaultHandlerID, (String)readResponse.getHandlerID());
        CalibrationResponseTester.assertEquals((String)"getUserID", (String)defaultUserID, (String)readResponse.getUserID());
        CalibrationResponseTester.assertEquals((String)"getInSpec", (boolean)defaultInSpec, (boolean)readResponse.getInSpec());
    }

    public void testGetChannelDottedName() {
        CalibrationResponseTester.assertEquals((String)"Get dotted channel name", (String)(String.valueOf(defaultStation) + "." + defaultChannel), (String)this.calResponse.getDottedChannelName());
    }
}

