/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.PRBCalibrationCommandPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PRBCalibrationCommandPacketTest
extends TestCase {
    int timeSecs;
    int instrumentID;
    byte channelBits;
    byte subtype;
    byte ctrlLines;
    byte attenuation;
    float amplitude;
    byte amplitudeUnit;
    float dcOffset;
    float duration;
    float tOn;
    float ramp;
    String identifier;
    int unitPulseWidth;
    int mask;
    int seed;
    PRBCalibrationCommandPacket packet;
    static /* synthetic */ Class class$0;

    public PRBCalibrationCommandPacketTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.PRBCalibrationCommandPacketTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        this.timeSecs = 10;
        this.instrumentID = 5;
        this.channelBits = 1;
        this.subtype = (byte)2;
        this.amplitudeUnit = (byte)3;
        this.ctrlLines = (byte)4;
        this.attenuation = 1;
        this.amplitude = 2.0f;
        this.dcOffset = 1.0f;
        this.duration = 30.3f;
        this.tOn = 12.0f;
        this.ramp = 12.3f;
        this.identifier = "test";
        this.unitPulseWidth = 2300;
        this.mask = 1;
        this.seed = 1;
        this.packet = new PRBCalibrationCommandPacket(this.timeSecs, this.instrumentID, this.channelBits, this.ctrlLines, this.attenuation, this.amplitudeUnit, this.amplitude, this.dcOffset, this.tOn, this.duration, this.ramp, this.identifier, this.unitPulseWidth, this.mask, this.seed);
    }

    public void testConstructor() throws Exception {
        PRBCalibrationCommandPacketTest.assertNotNull((String)"null regular constructor", (Object)this.packet);
    }

    public void testGets() throws Exception {
        PRBCalibrationCommandPacketTest.assertEquals((String)"getUnitPulseWidth()", (int)this.unitPulseWidth, (int)this.packet.getUnitPulseWidth());
        PRBCalibrationCommandPacketTest.assertEquals((String)"getPolynomialMask()", (int)this.mask, (int)this.packet.getPolynomialMask());
        PRBCalibrationCommandPacketTest.assertEquals((String)"getSeed()", (int)this.seed, (int)this.packet.getSeed());
    }

    public void testSets() throws Exception {
        this.unitPulseWidth = 400;
        this.packet.setUnitPulseWidth(this.unitPulseWidth);
        PRBCalibrationCommandPacketTest.assertEquals((String)"setUnitPulseWidth()", (int)this.unitPulseWidth, (int)this.packet.getUnitPulseWidth());
        this.mask = -1;
        this.packet.setPolynomialMask(this.mask);
        PRBCalibrationCommandPacketTest.assertEquals((String)"setPolynomialMask()", (int)this.mask, (int)this.packet.getPolynomialMask());
        this.seed = -1;
        this.packet.setSeed(this.seed);
        PRBCalibrationCommandPacketTest.assertEquals((String)"setSeed()", (int)this.seed, (int)this.packet.getSeed());
    }

    public void testPackable() throws Exception {
        byte[] buffer = new byte[this.packet.getDataLength() + 2];
        this.packet.writeTo(buffer, 2);
        PRBCalibrationCommandPacket packedPacket = new PRBCalibrationCommandPacket(buffer, 2, buffer.length);
        PRBCalibrationCommandPacketTest.assertEquals((String)"getUnitPulseWidth()", (int)this.unitPulseWidth, (int)packedPacket.getUnitPulseWidth());
        PRBCalibrationCommandPacketTest.assertEquals((String)"getPolynomialMask()", (int)this.mask, (int)packedPacket.getPolynomialMask());
        PRBCalibrationCommandPacketTest.assertEquals((String)"getSeed()", (int)this.seed, (int)packedPacket.getSeed());
    }
}

