/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.WNCalibrationCommandPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class WNCalibrationCommandPacketTest
extends TestCase {
    int timeSecs;
    int instrumentID;
    byte channelBits;
    byte subtype;
    byte ctrlLines;
    byte attenuation;
    float amplitude;
    byte amplitudeUnit;
    float dcOffset;
    float duration;
    float tOn;
    float ramp;
    String identifier;
    int unitPulseWidth;
    int mask;
    int seed;
    int bits;
    WNCalibrationCommandPacket packet;
    static /* synthetic */ Class class$0;

    public WNCalibrationCommandPacketTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.WNCalibrationCommandPacketTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        this.timeSecs = 10;
        this.instrumentID = 5;
        this.channelBits = 1;
        this.subtype = (byte)2;
        this.amplitudeUnit = (byte)3;
        this.ctrlLines = (byte)4;
        this.attenuation = 1;
        this.amplitude = 2.0f;
        this.dcOffset = 1.0f;
        this.duration = 30.3f;
        this.tOn = 12.0f;
        this.ramp = 12.3f;
        this.identifier = "test";
        this.unitPulseWidth = 2300;
        this.mask = 1;
        this.seed = 2;
        this.bits = 3;
        this.packet = new WNCalibrationCommandPacket(this.timeSecs, this.instrumentID, this.channelBits, this.ctrlLines, this.attenuation, this.amplitudeUnit, this.amplitude, this.dcOffset, this.tOn, this.ramp, this.duration, this.identifier, this.unitPulseWidth, this.mask, this.seed, this.bits);
    }

    public void testConstructor() throws Exception {
        WNCalibrationCommandPacketTest.assertNotNull((String)"null regular constructor", (Object)this.packet);
    }

    public void testGets() throws Exception {
        WNCalibrationCommandPacketTest.assertEquals((String)"getUnitPulseWidth()", (int)this.unitPulseWidth, (int)this.packet.getUnitPulseWidth());
        WNCalibrationCommandPacketTest.assertEquals((String)"getPolynomialMask()", (int)this.mask, (int)this.packet.getPolynomialMask());
        WNCalibrationCommandPacketTest.assertEquals((String)"getSeed()", (int)this.seed, (int)this.packet.getSeed());
        WNCalibrationCommandPacketTest.assertEquals((String)"getBits()", (int)this.bits, (int)this.packet.getBits());
    }

    public void testSets() throws Exception {
        this.unitPulseWidth = 400;
        this.packet.setUnitPulseWidth(this.unitPulseWidth);
        WNCalibrationCommandPacketTest.assertEquals((String)"setUnitPulseWidth()", (int)this.unitPulseWidth, (int)this.packet.getUnitPulseWidth());
        this.mask = -1;
        this.packet.setPolynomialMask(this.mask);
        WNCalibrationCommandPacketTest.assertEquals((String)"setPolynomialMask()", (int)this.mask, (int)this.packet.getPolynomialMask());
        this.seed = -1;
        this.packet.setSeed(this.seed);
        WNCalibrationCommandPacketTest.assertEquals((String)"setSeed()", (int)this.seed, (int)this.packet.getSeed());
        this.bits = -1;
        this.packet.setBits(this.bits);
        WNCalibrationCommandPacketTest.assertEquals((String)"setBits()", (int)this.bits, (int)this.packet.getBits());
    }

    public void testPackable() throws Exception {
        byte[] buffer = new byte[this.packet.getDataLength() + 2];
        this.packet.writeTo(buffer, 2);
        WNCalibrationCommandPacket packedPacket = new WNCalibrationCommandPacket(buffer, 2, buffer.length);
        WNCalibrationCommandPacketTest.assertEquals((String)"getUnitPulseWidth()", (int)this.unitPulseWidth, (int)packedPacket.getUnitPulseWidth());
        WNCalibrationCommandPacketTest.assertEquals((String)"getPolynomialMask()", (int)this.mask, (int)packedPacket.getPolynomialMask());
        WNCalibrationCommandPacketTest.assertEquals((String)"getSeed()", (int)this.seed, (int)packedPacket.getSeed());
        WNCalibrationCommandPacketTest.assertEquals((String)"getBits()", (int)this.bits, (int)packedPacket.getBits());
    }
}

