/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.HierarchalObservableChanged;
import ca.nanometrics.util.HierarchalObservableChangedEmptyEntry;
import ca.nanometrics.util.HierarchalObservableChangedEntry;
import ca.nanometrics.util.HierarchalObservableChangedList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class HierarchalObservable
extends Observable
implements Observer {
    private boolean activeObserver = true;
    private boolean receivedChangeNotify = false;
    private List observedObjects = new ArrayList();
    private HierarchalObservableChanged hierarchalObservableChanged;

    public void setActiveObserver(boolean active) {
        this.activeObserver = active;
    }

    public void observeHierarchalObservable(HierarchalObservable object) {
        if (object != null) {
            this.observedObjects.add(object);
            object.addObserver(this);
        }
    }

    public void unobserveHierarchalObservable(HierarchalObservable object) {
        if (object != null) {
            this.observedObjects.remove(object);
            object.deleteObserver(this);
        }
    }

    public void notifyThisObjectsObservers() {
        this.setActiveObserver(false);
        this.createAndSetHierarchalObservableChanged();
        this.notifyObservers();
        this.setActiveObserver(true);
        this.removeHierarchalObservableChanged();
    }

    public void notifyHierarchy() {
        this.setActiveHierarchy(false);
        this.createHierarchalObservableChangedHierarchy();
        this.notifyObserversHierarchy();
        this.setActiveHierarchy(true);
        this.removeHierarchalObservableChangedHierarchy();
    }

    private HierarchalObservableChanged createHierarchalObservableChangedHierarchy() {
        if (this.observedObjects.size() == 0) {
            this.createAndSetHierarchalObservableChanged();
            return this.getHierarchalObservableChanged();
        }
        this.setHierarchalObservableChanged(new HierarchalObservableChangedList());
        this.getHierarchalObservableChanged().addComponent(this.createHierarchalObservableChanged());
        Iterator iter = this.getObserveredObjectsIterator();
        while (iter.hasNext()) {
            HierarchalObservable obj = (HierarchalObservable)iter.next();
            this.getHierarchalObservableChanged().addComponent(obj.createHierarchalObservableChangedHierarchy());
        }
        return this.getHierarchalObservableChanged();
    }

    private void createAndSetHierarchalObservableChanged() {
        this.setHierarchalObservableChanged(this.createHierarchalObservableChanged());
    }

    private HierarchalObservableChanged createHierarchalObservableChanged() {
        if (this.hasChanged()) {
            return new HierarchalObservableChangedEntry(this);
        }
        return new HierarchalObservableChangedEmptyEntry(this);
    }

    private void createHierarchalObservableChangedAdding(HierarchalObservableChanged aChanged) {
        HierarchalObservableChangedList aList = new HierarchalObservableChangedList();
        aList.addComponent(aChanged);
        aList.addComponent(this.createHierarchalObservableChanged());
        this.setHierarchalObservableChanged(aList);
    }

    private void removeHierarchalObservableChangedHierarchy() {
        Iterator iter = this.getObserveredObjectsIterator();
        while (iter.hasNext()) {
            HierarchalObservable obj = (HierarchalObservable)iter.next();
            obj.removeHierarchalObservableChangedHierarchy();
        }
        this.removeHierarchalObservableChanged();
    }

    private void removeHierarchalObservableChanged() {
        if (this.getHierarchalObservableChanged() != null) {
            this.getHierarchalObservableChanged().dispose();
            this.setHierarchalObservableChanged(null);
        }
    }

    private void removeHierarchalObservableChangedExcept(HierarchalObservableChanged exemptChanged) {
        HierarchalObservableChanged aChanged = this.getHierarchalObservableChanged();
        if (aChanged != null) {
            Iterator i = aChanged.getComponents();
            while (i.hasNext()) {
                HierarchalObservableChanged nextChanged = (HierarchalObservableChanged)i.next();
                if (nextChanged == exemptChanged) continue;
                nextChanged.dispose();
            }
            aChanged.dispose();
            this.setHierarchalObservableChanged(null);
        }
    }

    private void setActiveHierarchy(boolean active) {
        Iterator iter = this.getObserveredObjectsIterator();
        while (iter.hasNext()) {
            HierarchalObservable obj = (HierarchalObservable)iter.next();
            obj.setActiveHierarchy(active);
        }
        this.setActiveObserver(active);
    }

    private void notifyObserversHierarchy() {
        ArrayList clonedList = new ArrayList(this.observedObjects);
        Iterator iter = clonedList.iterator();
        while (iter.hasNext()) {
            HierarchalObservable obj = (HierarchalObservable)iter.next();
            obj.notifyObserversHierarchy();
        }
        this.notifyObservers();
    }

    public void notifyObservers() {
        if (this.receivedChangeNotify) {
            this.receivedChangeNotify = false;
            this.setChanged();
        }
        super.notifyObservers(this.getHierarchalObservableChanged());
    }

    public boolean isActiveObserver() {
        return this.activeObserver;
    }

    public void update(Observable o, Object arg) {
        this.localUpdate(o, arg);
        if (!(o instanceof HierarchalObservable)) {
            return;
        }
        if (this.isActiveObserver()) {
            this.createHierarchalObservableChangedAdding((HierarchalObservableChanged)arg);
            this.setChanged();
            super.notifyObservers(this.getHierarchalObservableChanged());
            this.removeHierarchalObservableChangedExcept((HierarchalObservableChanged)arg);
        } else {
            this.receivedChangeNotify = true;
        }
    }

    protected void localUpdate(Observable o, Object arg) {
    }

    private void setHierarchalObservableChanged(HierarchalObservableChanged aHierarchalObservableChanged) {
        this.hierarchalObservableChanged = aHierarchalObservableChanged;
    }

    private HierarchalObservableChanged getHierarchalObservableChanged() {
        return this.hierarchalObservableChanged;
    }

    private Iterator getObserveredObjectsIterator() {
        return this.observedObjects.iterator();
    }
}

