/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class NmxDateFormat
extends SimpleDateFormat {
    public NmxDateFormat(String format) {
        super(format);
        this.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public NmxDateFormat() {
        this("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String format(double time) {
        return this.format(new Date((long)(1000.0 * time)));
    }

    public static Date parseDate(String text) {
        StringTokenizer st = new StringTokenizer(text, " -_/:");
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        try {
            year = Integer.parseInt(st.nextToken());
            month = Integer.parseInt(st.nextToken()) - 1;
            day = Integer.parseInt(st.nextToken());
            hour = Integer.parseInt(st.nextToken());
            minute = Integer.parseInt(st.nextToken());
            double dsec = Double.parseDouble(st.nextToken());
            second = (int)dsec;
            millis = (int)(1000.0 * (dsec - (double)second) + 0.5);
        }
        catch (Exception dsec) {
            // empty catch block
        }
        GregorianCalendar gc = new GregorianCalendar(year, month, day, hour, minute, second);
        gc.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = gc.getTime();
        date.setTime(date.getTime() + (long)millis);
        return date;
    }
}

